/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.decorator;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import jaxx.runtime.decorator.Decorator;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyDecorator<O>
extends Decorator<O> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(PropertyDecorator.class);
    protected String property;
    protected transient Method m;

    @Override
    public String toString(Object bean) {
        try {
            return this.getM().invoke(bean, new Object[0]) + "";
        }
        catch (Exception e) {
            log.error((Object)("could not convert for reason : " + e), (Throwable)e);
            return "";
        }
    }

    public String getProperty() {
        return this.property;
    }

    protected PropertyDecorator(Class<O> internalClass, String property) throws NullPointerException {
        super(internalClass);
        if (property == null) {
            throw new NullPointerException("property can not be null.");
        }
        this.property = property;
        this.getM();
    }

    protected Method getM() {
        if (this.m == null) {
            for (PropertyDescriptor propertyDescriptor : PropertyUtils.getPropertyDescriptors((Class)this.internalClass)) {
                if (!propertyDescriptor.getName().equals(this.property)) continue;
                this.m = propertyDescriptor.getReadMethod();
                break;
            }
            if (this.m == null) {
                throw new IllegalArgumentException("could not find the property " + this.property + " in " + this.internalClass);
            }
        }
        return this.m;
    }
}

