/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserHelper;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class VradiUserAbstract extends BusinessEntityImpl implements VradiUser {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionVradiUser;
    /**
     * getEmail :
     * @return String 
     */

    @Override
    public String getEmail() {
        String value = VradiUserHelper.getEmail(getWikitty());
        return value;
}

    /**
     * setEmail :
     * @param email 
     */

    @Override
    public void setEmail(String email) {
        String oldValue = getEmail();
        VradiUserHelper.setEmail(getWikitty(), email);
        getPropertyChangeSupport().firePropertyChange(VradiUser.FIELD_VRADIUSER_EMAIL, oldValue, getEmail());
}

    /**
     * getLogin :
     * @return String 
     */

    public String getLogin() {
        String value = WikittyUserHelper.getLogin(getWikitty());
        return value;
}

    /**
     * setLogin :
     * @param login 
     */

    public void setLogin(String login) {
        String oldValue = getLogin();
        WikittyUserHelper.setLogin(getWikitty(), login);
        getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_LOGIN, oldValue, getLogin());
}

    /**
     * getPassword :
     * @return String 
     */

    public String getPassword() {
        String value = WikittyUserHelper.getPassword(getWikitty());
        return value;
}

    /**
     * setPassword :
     * @param password 
     */

    public void setPassword(String password) {
        String oldValue = getPassword();
        WikittyUserHelper.setPassword(getWikitty(), password);
        getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_PASSWORD, oldValue, getPassword());
}

    /**
     * VradiUserAbstract :
     */

    public VradiUserAbstract() {
        super();
}

    /**
     * VradiUserAbstract :
     * @param wikitty 
     */

    public VradiUserAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * VradiUserAbstract :
     * @param businessEntityImpl 
     */

    public VradiUserAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionVradiUser =
                new WikittyExtension(EXT_VRADIUSER,
                                     "2.0", // version
                                     WikittyUser.EXT_WIKITTYUSER,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String email unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(WikittyUserAbstract.extensions); 
        // current after requires ones

        exts.add(extensionVradiUser);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //VradiUserAbstract
