/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class GroupAbstract extends BusinessEntityImpl implements Group {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionGroup;
    /**
     * getName :
     * @return String 
     */

    @Override
    public String getName() {
        String value = GroupHelper.getName(getWikitty());
        return value;
}

    /**
     * setName :
     * @param name 
     */

    @Override
    public void setName(String name) {
        String oldValue = getName();
        GroupHelper.setName(getWikitty(), name);
        getPropertyChangeSupport().firePropertyChange(Group.FIELD_GROUP_NAME, oldValue, getName());
}

    /**
     * getUser :
     * @return Set<String> 
     */

    @Override
    public Set<String> getUser() {
        Set<String> result = GroupHelper.getUser(getWikitty());
        return result;
}

    /**
     * setUser :
     * @param user 
     */

    @Override
    public void setUser(Set<String> user) {
        Set<String> oldValue = getUser();
        GroupHelper.setUser(getWikitty(), user);
        getPropertyChangeSupport().firePropertyChange(Group.FIELD_GROUP_USER, oldValue, getUser());
}

    /**
     * addAllUser :
     * @param user 
     */

    @Override
    public void addAllUser(Set<String> user) {
        Set<String> oldValue = getUser();
        GroupHelper.addAllUser(getWikitty(), user);
        getPropertyChangeSupport().firePropertyChange(Group.FIELD_GROUP_USER, oldValue, getUser());
}

    /**
     * addUser :
     * @param element 
     */

    @Override
    public void addUser(String element) {
        GroupHelper.addUser(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Group.FIELD_GROUP_USER, null, getUser());
}

    /**
     * removeUser :
     * @param element 
     */

    @Override
    public void removeUser(String element) {
        GroupHelper.removeUser(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Group.FIELD_GROUP_USER, null, getUser());
}

    /**
     * clearUser :
     */

    @Override
    public void clearUser() {
        GroupHelper.clearUser(getWikitty());
        getPropertyChangeSupport().firePropertyChange(Group.FIELD_GROUP_USER, null, getUser());
}

    /**
     * getQueries :
     * @return Set<String> 
     */

    public Set<String> getQueries() {
        Set<String> result = QueryMakerHelper.getQueries(getWikitty());
        return result;
}

    /**
     * setQueries :
     * @param queries 
     */

    public void setQueries(Set<String> queries) {
        Set<String> oldValue = getQueries();
        QueryMakerHelper.setQueries(getWikitty(), queries);
        getPropertyChangeSupport().firePropertyChange(QueryMaker.FIELD_QUERYMAKER_QUERIES, oldValue, getQueries());
}

    /**
     * addAllQueries :
     * @param queries 
     */

    public void addAllQueries(Set<String> queries) {
        Set<String> oldValue = getQueries();
        QueryMakerHelper.addAllQueries(getWikitty(), queries);
        getPropertyChangeSupport().firePropertyChange(QueryMaker.FIELD_QUERYMAKER_QUERIES, oldValue, getQueries());
}

    /**
     * addQueries :
     * @param element 
     */

    public void addQueries(String element) {
        QueryMakerHelper.addQueries(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(QueryMaker.FIELD_QUERYMAKER_QUERIES, null, getQueries());
}

    /**
     * removeQueries :
     * @param element 
     */

    public void removeQueries(String element) {
        QueryMakerHelper.removeQueries(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(QueryMaker.FIELD_QUERYMAKER_QUERIES, null, getQueries());
}

    /**
     * clearQueries :
     */

    public void clearQueries() {
        QueryMakerHelper.clearQueries(getWikitty());
        getPropertyChangeSupport().firePropertyChange(QueryMaker.FIELD_QUERYMAKER_QUERIES, null, getQueries());
}

    /**
     * GroupAbstract :
     */

    public GroupAbstract() {
        super();
}

    /**
     * GroupAbstract :
     * @param wikitty 
     */

    public GroupAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * GroupAbstract :
     * @param businessEntityImpl 
     */

    public GroupAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionGroup =
                new WikittyExtension(EXT_GROUP,
                                     "3.0", // version
                                     QueryMaker.EXT_QUERYMAKER,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String name unique=\"true\"", 
                                             "Wikitty user[0-*] unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(QueryMakerAbstract.extensions); 
        // current after requires ones

        exts.add(extensionGroup);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //GroupAbstract
