/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class ClientHelper {

    /**
     * ClientHelper :
     * utility class all provided methods are accessible the static way
     */

    private ClientHelper() {// empty
}

    /**
     * getName :
     * @param wikitty 
     * @return String 
     */

    public static String getName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Client.EXT_CLIENT, Client.FIELD_CLIENT_NAME);
        return value;
}

    /**
     * setName :
     * @param wikitty 
     * @param name 
     * @return String 
     */

    public static String setName(Wikitty wikitty, String name) {
        String oldValue = getName(wikitty);
        wikitty.setField(Client.EXT_CLIENT, Client.FIELD_CLIENT_NAME, name);
        return oldValue;
}

    /**
     * getCreationDate :
     * @param wikitty 
     * @return Date 
     */

    public static Date getCreationDate(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(Client.EXT_CLIENT, Client.FIELD_CLIENT_CREATIONDATE);
        return value;
}

    /**
     * setCreationDate :
     * @param wikitty 
     * @param creationDate 
     * @return Date 
     */

    public static Date setCreationDate(Wikitty wikitty, Date creationDate) {
        Date oldValue = getCreationDate(wikitty);
        wikitty.setField(Client.EXT_CLIENT, Client.FIELD_CLIENT_CREATIONDATE, creationDate);
        return oldValue;
}

    /**
     * getAddress :
     * @param wikitty 
     * @return String 
     */

    public static String getAddress(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Client.EXT_CLIENT, Client.FIELD_CLIENT_ADDRESS);
        return value;
}

    /**
     * setAddress :
     * @param wikitty 
     * @param address 
     * @return String 
     */

    public static String setAddress(Wikitty wikitty, String address) {
        String oldValue = getAddress(wikitty);
        wikitty.setField(Client.EXT_CLIENT, Client.FIELD_CLIENT_ADDRESS, address);
        return oldValue;
}

    /**
     * getPhone :
     * @param wikitty 
     * @return String 
     */

    public static String getPhone(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Client.EXT_CLIENT, Client.FIELD_CLIENT_PHONE);
        return value;
}

    /**
     * setPhone :
     * @param wikitty 
     * @param phone 
     * @return String 
     */

    public static String setPhone(Wikitty wikitty, String phone) {
        String oldValue = getPhone(wikitty);
        wikitty.setField(Client.EXT_CLIENT, Client.FIELD_CLIENT_PHONE, phone);
        return oldValue;
}

    /**
     * getContact :
     * @param wikitty 
     * @return String 
     */

    public static String getContact(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Client.EXT_CLIENT, Client.FIELD_CLIENT_CONTACT);
        return value;
}

    /**
     * setContact :
     * @param wikitty 
     * @param contact 
     * @return String 
     */

    public static String setContact(Wikitty wikitty, String contact) {
        String oldValue = getContact(wikitty);
        wikitty.setField(Client.EXT_CLIENT, Client.FIELD_CLIENT_CONTACT, contact);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Client.EXT_CLIENT, Client.FIELD_CLIENT_NAME);
            Object f2 = w2.getFieldAsObject(Client.EXT_CLIENT, Client.FIELD_CLIENT_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Client.EXT_CLIENT, Client.FIELD_CLIENT_CREATIONDATE);
            Object f2 = w2.getFieldAsObject(Client.EXT_CLIENT, Client.FIELD_CLIENT_CREATIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Client.EXT_CLIENT, Client.FIELD_CLIENT_ADDRESS);
            Object f2 = w2.getFieldAsObject(Client.EXT_CLIENT, Client.FIELD_CLIENT_ADDRESS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Client.EXT_CLIENT, Client.FIELD_CLIENT_PHONE);
            Object f2 = w2.getFieldAsObject(Client.EXT_CLIENT, Client.FIELD_CLIENT_PHONE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Client.EXT_CLIENT, Client.FIELD_CLIENT_CONTACT);
            Object f2 = w2.getFieldAsObject(Client.EXT_CLIENT, Client.FIELD_CLIENT_CONTACT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Client.EXT_CLIENT);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : ClientAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //ClientHelper
