/*
 * #%L
 * SGQ :: Web
 * $Id: ProductStatusListAction.java 292 2013-03-25 11:35:42Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/ProductStatusListAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.util.Map;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.ProductStatus;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;

public class ProductStatusListAction extends SgqActionSupport implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 5564446302091087009L;

    protected ReferentialService referentialService;

    protected Map<ProductStatus, Long> productStatuses;

    protected String productStatusId;

    @Override
    public void prepare() throws Exception {
        // traite ici les parametres que struts aura du mal a gere ti seul
        referentialService = newService(ReferentialService.class);
    }

    @Override
    public String execute() throws Exception {

        productStatuses = referentialService.findAllProductStatusWithCount();
        return SUCCESS;
    }

    public Map<ProductStatus, Long> getProductStatuses() {
        return productStatuses;
    }

    public void setProductStatusId(String productStatusId) {
        this.productStatusId = productStatusId;
    }

    @Action(value="product-status-delete", results={@Result(type="redirectAction", params = {"actionName" , "product-status-list"})})
    public String delete() {
        ProductStatus productStatus = referentialService.getProductStatusById(productStatusId);
        referentialService.deleteProductStatus(productStatus);
        return SUCCESS;
    }
}
