/*
 * #%L
 * SGQ :: Web
 * $Id: BatchViewAction.java 171 2012-10-19 16:52:07Z echatellier $
 * $HeadURL: https://svn.codelutin.com/sgq-ch/tags/sgq-ch-1.1.6/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/BatchViewAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.util.List;

import com.herbocailleau.sgq.business.model.BatchModel;
import com.herbocailleau.sgq.business.model.PresentationModel;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.entities.AnalyzeFile;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchAnalyze;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action de detail d'un lot.
 * Comprenant detail du lot, analyses et presentation.
 * 
 * @author echatellier
 */
public class BatchViewAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected String batchId;

    protected BatchModel batchModel;

    protected List<PresentationModel> presentationModels;

    protected List<BatchAnalyze> analyzes;

    protected List<AnalyzeFile> analyzeFiles;

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @Override
    public String execute() throws Exception {

        BatchService batchService = newService(BatchService.class);
        batchModel = batchService.getBatchModelById(batchId);

        presentationModels = batchService.findAllPresentationsByBatch(getBatch());
        analyzes = batchService.findAllAnalyzesByBatch(getBatch());
        analyzeFiles = batchService.findAllAnalyzeFilesByBatch(getBatch());
        return SUCCESS;
    }

    public Batch getBatch() {
        return batchModel.getBatch();
    }

    public BatchModel getBatchModel() {
        return batchModel;
    }

    public List<PresentationModel> getPresentationModels() {
        return presentationModels;
    }

    public List<BatchAnalyze> getAnalyzes() {
        return analyzes;
    }

    public List<AnalyzeFile> getAnalyzeFiles() {
        return analyzeFiles;
    }
}
