/*
 * #%L
 * SGQ :: Web
 * $Id: BatchReceiveLimit.java 322 2013-04-17 16:10:16Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.3/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/BatchReceiveLimit.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.SgqBusinessConfig;
import com.herbocailleau.sgq.business.services.ConfigurationService;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;

/**
 * Action de modification des bornes d'import de fichier lot.
 * 
 * @author echatellier
 */
public class BatchReceiveLimit extends SgqActionSupport implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 4211084787152505568L;

    protected ConfigurationService configurationService;

    protected int nextNonBioBatchNumber;

    protected int lastNonBioBatchNumber;

    protected int nextBioBatchNumber;
    
    protected int lastBioBatchNumber;

    @Override
    public void prepare() throws Exception {
        configurationService = newService(ConfigurationService.class);
    }

    public int getNextNonBioBatchNumber() {
        return nextNonBioBatchNumber;
    }

    public void setNextNonBioBatchNumber(int nextNonBioBatchNumber) {
        this.nextNonBioBatchNumber = nextNonBioBatchNumber;
    }

    public int getNextBioBatchNumber() {
        return nextBioBatchNumber;
    }

    public void setNextBioBatchNumber(int nextBioBatchNumber) {
        this.nextBioBatchNumber = nextBioBatchNumber;
    }

    public int getLastNonBioBatchNumber() {
        return lastNonBioBatchNumber;
    }

    public int getLastBioBatchNumber() {
        return lastBioBatchNumber;
    }

    @Override
    public String input() throws Exception {
        nextNonBioBatchNumber = configurationService.getNextNonBioBatchNumber();
        nextBioBatchNumber = configurationService.getNextBioBatchNumber();
        lastNonBioBatchNumber = configurationService.getLastNonBioBatchNumber();
        lastBioBatchNumber = configurationService.getLastBioBatchNumber();
        return INPUT;
    }

    @Override
    public void validate() {
        SgqBusinessConfig config = getConfig();
        if (nextNonBioBatchNumber < config.getBatchRangeNonBioStart()) {
            addActionError("Le numero de lot pour les plantes conventionnelle ne peut pas être inférieur à " + config.getBatchRangeNonBioStart());
        }
        if (nextBioBatchNumber < config.getBatchRangeBioStart()) {
            addActionError("Le numero de lot pour les plantes conventionnelle ne peut pas être inférieur à " + config.getBatchRangeBioStart());
        }
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName", "batch-receive-view"})})
    public String execute() throws Exception {
        configurationService.saveBatchLimit(nextNonBioBatchNumber, nextBioBatchNumber);
        return SUCCESS;
    }
}
