/*
 * #%L
 * SGQ :: Web
 * $Id: AnalyzePrepareAction.java 258 2013-01-30 11:38:59Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.1/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/AnalyzePrepareAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.util.List;

import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeCategory;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;

/**
 * Action de preparation des analyses pour plusieurs lots.
 * 
 * @author echatellier
 */
public class AnalyzePrepareAction extends SgqActionSupport implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected BatchService batchService;

    protected ReferentialService referentialService;

    protected int startNumber;

    protected int endNumber;

    protected List<Batch> batches;

    protected MultiKeyMap existingAnalyzes;

    protected List<AnalyzeCategory> analyzeCategories;

    protected List<String> batchIds;

    public void setStartNumber(int startNumber) {
        this.startNumber = startNumber;
    }

    public int getStartNumber() {
        return startNumber;
    }

    public void setEndNumber(int endNumber) {
        this.endNumber = endNumber;
    }

    public int getEndNumber() {
        return endNumber;
    }

    @Override
    public void prepare() throws Exception {
        batchService = newService(BatchService.class);
        referentialService = newService(ReferentialService.class);
    }
 
    @Override
    public String input() throws Exception {

        if (startNumber != 0 && endNumber != 0) {
            batches = batchService.findAllBetweenNumbers(startNumber, endNumber);
            existingAnalyzes = batchService.findAllAnalyzesBetweenBatchNumbers(startNumber, endNumber);
            analyzeCategories = referentialService.findAllAnalyzeCategories();
        }

        return super.input();
    }

    public List<Batch> getBatches() {
        return batches;
    }
    
    public MultiKeyMap getExistingAnalyzes() {
        return existingAnalyzes;
    }

    public List<AnalyzeCategory> getAnalyzeCategories() {
        return analyzeCategories;
    }

    public void setBatchIds(List<String> batchIds) {
        this.batchIds = batchIds;
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName", "analyze-dashboard"})})
    public String execute() throws Exception {
        String result = null;
        if (batchIds == null) {
            result = input();
        } else {
            for (String batchId : batchIds) {
                Batch batch = batchService.getBatchById(batchId);
    
                String[] analyzeTypeIds = getParameters("analyzeType." + batch.getTopiaId());
                if (analyzeTypeIds != null) {
                    for (String analyzeTypeId : analyzeTypeIds) {
                        AnalyzeType analyzeType = referentialService.findAnalyzeTypeById(analyzeTypeId);
                        batchService.prepareAnalyze(batch, analyzeType);
                    }
                }
                result = SUCCESS;
            }
        }

        return result;
    }
}
