/*
 * #%L
 * SGQ :: Web
 * $Id: AnalyzeTypeListAction.java 292 2013-03-25 11:35:42Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.0/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/AnalyzeTypeListAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.util.Map;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeCategory;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class AnalyzeTypeListAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6915148559808770928L;

    protected Map<AnalyzeCategory, Long> analyzeCategories;

    protected Map<AnalyzeType, Long> analyzeTypes;

    @Override
    public String execute() throws Exception {
        
        ReferentialService referentialService = newService(ReferentialService.class);
        analyzeCategories = referentialService.findAllAnalyzeCategoriesWithCount();
        analyzeTypes = referentialService.findAllAnalyzeTypesWithCount();

        return SUCCESS;
    }

    public Map<AnalyzeCategory, Long> getAnalyzeCategories() {
        return analyzeCategories;
    }

    public Map<AnalyzeType, Long> getAnalyzeTypes() {
        return analyzeTypes;
    }
}
