/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service;

import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroupTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.Stamp;
import com.franciaflex.faxtomail.persistence.entities.StampTopiaDao;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;
import com.franciaflex.faxtomail.services.service.UserService;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import org.hibernate.Hibernate;
import org.nuiton.topia.persistence.TopiaEntity;

public class UserServiceImpl
extends FaxToMailServiceSupport
implements UserService {
    @Override
    public long getActiveUserCount() {
        FaxToMailUserTopiaDao faxtomailUserDao = this.getPersistenceContext().getFaxToMailUserDao();
        long result = faxtomailUserDao.forHiddenEquals(false).count();
        return result;
    }

    @Override
    public long getActiveGroupCount() {
        FaxToMailUserGroupTopiaDao faxtomailUserGroupDao = this.getPersistenceContext().getFaxToMailUserGroupDao();
        long result = faxtomailUserGroupDao.forHiddenEquals(false).count();
        return result;
    }

    @Override
    public List<FaxToMailUser> getAllActiveUsers() {
        FaxToMailUserTopiaDao dao = this.getPersistenceContext().getFaxToMailUserDao();
        return dao.forHiddenEquals(false).setOrderByArguments(new String[]{"firstName", "lastName"}).findAll();
    }

    @Override
    public FaxToMailUser getUserByLogin(String login) {
        FaxToMailUserTopiaDao dao = this.getPersistenceContext().getFaxToMailUserDao();
        FaxToMailUser user = (FaxToMailUser)dao.forLoginEquals(login).findUnique();
        return user;
    }

    @Override
    public List<FaxToMailUserGroup> getAllActiveUserGroups() {
        FaxToMailUserGroupTopiaDao dao = this.getPersistenceContext().getFaxToMailUserGroupDao();
        return dao.forHiddenEquals(false).setOrderByArguments(new String[]{"completeName"}).findAll();
    }

    @Override
    public FaxToMailUser getUser(String topiaId) {
        FaxToMailUserTopiaDao dao = this.getPersistenceContext().getFaxToMailUserDao();
        FaxToMailUser user = (FaxToMailUser)dao.forTopiaIdEquals(topiaId).findUnique();
        Hibernate.initialize((Object)user.getAffectedFolders());
        return user;
    }

    @Override
    public Stamp saveSigning(FaxToMailUser user, Stamp signing, boolean defaultSigning) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)signing);
        Preconditions.checkArgument((!signing.isPersisted() || user.containsSignings(signing) ? 1 : 0) != 0);
        StampTopiaDao stampDao = this.getPersistenceContext().getStampDao();
        FaxToMailUserTopiaDao userDao = this.getPersistenceContext().getFaxToMailUserDao();
        if (signing.isPersisted()) {
            stampDao.update((TopiaEntity)signing);
        } else {
            stampDao.create((TopiaEntity)signing);
            user.addSignings(signing);
            userDao.update((TopiaEntity)user);
        }
        if (defaultSigning) {
            user.setDefaultSigning(signing);
            userDao.update((TopiaEntity)user);
        }
        this.getPersistenceContext().commit();
        return signing;
    }

    @Override
    public void deleteSigning(FaxToMailUser user, Stamp signing) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)signing);
        Preconditions.checkArgument((!signing.isPersisted() || user.containsSignings(signing) ? 1 : 0) != 0);
        if (signing.isPersisted()) {
            StampTopiaDao stampDao = this.getPersistenceContext().getStampDao();
            FaxToMailUserTopiaDao userDao = this.getPersistenceContext().getFaxToMailUserDao();
            user.removeSignings(signing);
            if (signing.equals(user.getDefaultSigning())) {
                user.setDefaultSigning(null);
            }
            userDao.update((TopiaEntity)user);
            stampDao.delete(signing);
            this.getPersistenceContext().commit();
        }
    }

    @Override
    public Collection<Stamp> getPdfEditorStamps(FaxToMailUser user) {
        Preconditions.checkNotNull((Object)user);
        StampTopiaDao stampDao = this.getPersistenceContext().getStampDao();
        Collection result = stampDao.findAllForUser(user);
        return result;
    }
}

