/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.xwork2.util.PatternMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedVariablePatternMatcher
implements PatternMatcher<CompiledPattern> {
    @Override
    public boolean isLiteral(String pattern) {
        return pattern == null || pattern.indexOf(123) == -1;
    }

    @Override
    public CompiledPattern compilePattern(String data) {
        StringBuilder regex = new StringBuilder();
        if (data != null && data.length() > 0) {
            ArrayList<String> varNames = new ArrayList<String>();
            StringBuilder varName = null;
            block4: for (int x = 0; x < data.length(); ++x) {
                char c = data.charAt(x);
                switch (c) {
                    case '{': {
                        varName = new StringBuilder();
                        continue block4;
                    }
                    case '}': {
                        varNames.add(varName.toString());
                        regex.append("([^/]+)");
                        varName = null;
                        continue block4;
                    }
                    default: {
                        if (varName == null) {
                            regex.append(c);
                            continue block4;
                        }
                        varName.append(c);
                    }
                }
            }
            return new CompiledPattern(Pattern.compile(regex.toString()), varNames);
        }
        return null;
    }

    @Override
    public boolean match(Map<String, String> map, String data, CompiledPattern expr) {
        Matcher matcher;
        if (data != null && data.length() > 0 && (matcher = expr.getPattern().matcher(data)).matches()) {
            for (int x = 0; x < expr.getVariableNames().size(); ++x) {
                map.put(expr.getVariableNames().get(x), matcher.group(x + 1));
            }
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompiledPattern {
        private Pattern pattern;
        private List<String> variableNames;

        public CompiledPattern(Pattern pattern, List<String> variableNames) {
            this.pattern = pattern;
            this.variableNames = variableNames;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public List<String> getVariableNames() {
            return this.variableNames;
        }
    }
}

