/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics;

import java.io.IOException;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.PDPostScriptXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class PDXObject
implements COSObjectable {
    private final PDStream stream;

    public static PDXObject createXObject(COSBase base, String name, PDResources resources) throws IOException {
        if (base == null) {
            return null;
        }
        if (!(base instanceof COSStream)) {
            throw new IOException("Unexpected object type: " + base.getClass().getName());
        }
        COSStream stream = (COSStream)base;
        String subtype = stream.getNameAsString(COSName.SUBTYPE);
        if (COSName.IMAGE.getName().equals(subtype)) {
            return new PDImageXObject(new PDStream(stream), resources);
        }
        if (COSName.FORM.getName().equals(subtype)) {
            return new PDFormXObject(new PDStream(stream), name);
        }
        if (COSName.PS.getName().equals(subtype)) {
            return new PDPostScriptXObject(new PDStream(stream));
        }
        throw new IOException("Invalid XObject Subtype: " + subtype);
    }

    protected PDXObject(PDStream stream, COSName subtype) {
        this.stream = stream;
        stream.getStream().setName(COSName.TYPE, COSName.XOBJECT.getName());
        stream.getStream().setName(COSName.SUBTYPE, subtype.getName());
    }

    protected PDXObject(PDDocument document, COSName subtype) {
        this.stream = new PDStream(document);
        this.stream.getStream().setName(COSName.TYPE, COSName.XOBJECT.getName());
        this.stream.getStream().setName(COSName.SUBTYPE, subtype.getName());
    }

    @Override
    public final COSBase getCOSObject() {
        return this.stream.getCOSObject();
    }

    public final COSStream getCOSStream() {
        return this.stream.getStream();
    }

    public final PDStream getPDStream() {
        return this.stream;
    }
}

