/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DigestGenerator {
    public static final String UNICODE_BIG_UNMARKED = "UnicodeBigUnmarked";
    public static final String md5DigestAlgorithm = "MD5";
    public static final String shaDigestAlgorithm = "SHA";
    public static final String sha1DigestAlgorithm = "SHA1";

    public byte[] getDigest(Document document, String digestAlgorithm) throws Exception {
        byte[] digest;
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(9);
            Collection childNodes = this.getValidElements(document);
            dos.writeInt(childNodes.size());
            for (Object childNode : childNodes) {
                Node node = (Node)childNode;
                if (node.getNodeType() == 7) {
                    dos.write(this.getDigest((ProcessingInstruction)node, digestAlgorithm));
                    continue;
                }
                if (node.getNodeType() != 1) continue;
                dos.write(this.getDigest((Element)node, digestAlgorithm));
            }
            dos.close();
            md.update(baos.toByteArray());
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(e);
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        return digest;
    }

    public byte[] getDigest(Node node, String digestAlgorithm) throws Exception {
        if (node.getNodeType() == 1) {
            return this.getDigest((Element)node, digestAlgorithm);
        }
        if (node.getNodeType() == 3) {
            return this.getDigest((Text)node, digestAlgorithm);
        }
        if (node.getNodeType() == 7) {
            return this.getDigest((ProcessingInstruction)node, digestAlgorithm);
        }
        return new byte[0];
    }

    public byte[] getDigest(Element element, String digestAlgorithm) throws Exception {
        byte[] digest;
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(1);
            dos.write(this.getExpandedName(element).getBytes(UNICODE_BIG_UNMARKED));
            dos.write(0);
            dos.write(0);
            Collection attrs = this.getAttributesWithoutNS(element);
            dos.writeInt(attrs.size());
            for (Object attr : attrs) {
                dos.write(this.getDigest((Attr)attr, digestAlgorithm));
            }
            int length = element.getChildNodes().getLength();
            dos.writeInt(length);
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                dos.write(this.getDigest(node, digestAlgorithm));
            }
            dos.close();
            md.update(baos.toByteArray());
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(e);
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        return digest;
    }

    public byte[] getDigest(ProcessingInstruction pi, String digestAlgorithm) throws Exception {
        byte[] digest;
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            md.update((byte)0);
            md.update((byte)0);
            md.update((byte)0);
            md.update((byte)7);
            md.update(pi.getTarget().getBytes(UNICODE_BIG_UNMARKED));
            md.update((byte)0);
            md.update((byte)0);
            md.update(pi.getNodeValue().getBytes(UNICODE_BIG_UNMARKED));
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception(e);
        }
        return digest;
    }

    public byte[] getDigest(Attr attribute, String digestAlgorithm) throws Exception {
        byte[] digest = new byte[]{};
        if (!attribute.getLocalName().equals("xmlns") && !attribute.getLocalName().startsWith("xmlns:")) {
            try {
                MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
                md.update((byte)0);
                md.update((byte)0);
                md.update((byte)0);
                md.update((byte)2);
                md.update(this.getExpandedName(attribute).getBytes(UNICODE_BIG_UNMARKED));
                md.update((byte)0);
                md.update((byte)0);
                md.update(attribute.getValue().getBytes(UNICODE_BIG_UNMARKED));
                digest = md.digest();
            }
            catch (NoSuchAlgorithmException e) {
                throw new Exception(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new Exception(e);
            }
        }
        return digest;
    }

    public byte[] getDigest(Text text, String digestAlgorithm) throws Exception {
        byte[] digest;
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            md.update((byte)0);
            md.update((byte)0);
            md.update((byte)0);
            md.update((byte)3);
            md.update(text.getTextContent().getBytes(UNICODE_BIG_UNMARKED));
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new Exception(e);
        }
        return digest;
    }

    public String getExpandedName(Element element) {
        return element.getNamespaceURI() + ":" + element.getLocalName();
    }

    public String getExpandedName(Attr attribute) {
        return attribute.getNamespaceURI() + ":" + attribute.getLocalName();
    }

    public Collection getAttributesWithoutNS(Element element) {
        TreeMap<String, Attr> map = new TreeMap<String, Attr>();
        for (int i = 0; i < element.getAttributes().getLength(); ++i) {
            Attr attribute = (Attr)element.getAttributes().item(i);
            if (attribute.getLocalName().equals("xmlns") || attribute.getLocalName().startsWith("xmlns:")) continue;
            map.put(this.getExpandedName(attribute), attribute);
        }
        return map.values();
    }

    public Collection getValidElements(Document document) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList childNodes = document.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1 && node.getNodeType() != 7) continue;
            list.add(node);
        }
        return list;
    }

    public String getStringRepresentation(byte[] array) {
        String str = "";
        for (byte anArray : array) {
            str = str + anArray;
        }
        return str;
    }

    public boolean compareNode(Node node, Node comparingNode, String digestAlgorithm) throws Exception {
        return Arrays.equals(this.getDigest(node, digestAlgorithm), this.getDigest(comparingNode, digestAlgorithm));
    }

    public boolean compareDocument(Document document, Document comparingDocument, String digestAlgorithm) throws Exception {
        return Arrays.equals(this.getDigest(document, digestAlgorithm), this.getDigest(comparingDocument, digestAlgorithm));
    }

    public boolean compareAttribute(Attr attribute, Attr comparingAttribute, String digestAlgorithm) throws Exception {
        return Arrays.equals(this.getDigest(attribute, digestAlgorithm), this.getDigest(comparingAttribute, digestAlgorithm));
    }
}

