/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.filter.DecodeResult;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.FilterFactory;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.io.RandomAccessFile;
import org.apache.pdfbox.io.RandomAccessFileInputStream;
import org.apache.pdfbox.io.RandomAccessFileOutputStream;

public class COSStream
extends COSDictionary
implements Closeable {
    private static final Log LOG = LogFactory.getLog(COSStream.class);
    private static final int BUFFER_SIZE = 16384;
    private RandomAccess tempBuffer;
    private RandomAccess filteredBuffer;
    private RandomAccess unfilteredBuffer;
    private RandomAccessFileOutputStream filteredStream;
    private RandomAccessFileOutputStream unFilteredStream;
    private DecodeResult decodeResult;
    private File scratchFileFiltered;
    private File scratchFileUnfiltered;
    private final boolean scratchFiles;
    private final File scratchFileDirectory;

    public COSStream() {
        this(false, null);
    }

    public COSStream(COSDictionary dictionary) {
        this(dictionary, false, null);
    }

    public COSStream(boolean useScratchFiles, File scratchDirectory) {
        this.scratchFiles = useScratchFiles;
        this.scratchFileDirectory = scratchDirectory;
    }

    public COSStream(COSDictionary dictionary, boolean useScratchFiles, File scratchDirectory) {
        super(dictionary);
        this.scratchFiles = useScratchFiles;
        this.scratchFileDirectory = scratchDirectory;
    }

    private RandomAccess createBuffer(boolean filtered) throws IOException {
        if (this.scratchFiles) {
            return this.createScratchFile(filtered);
        }
        return new RandomAccessBuffer();
    }

    private RandomAccess createScratchFile(boolean filtered) {
        try {
            if (filtered) {
                this.deleteFile(this.scratchFileFiltered);
                this.scratchFileFiltered = File.createTempFile("PDFBox_streamf_", null, this.scratchFileDirectory);
                return new RandomAccessFile(this.scratchFileFiltered, "rw");
            }
            this.deleteFile(this.scratchFileUnfiltered);
            this.scratchFileUnfiltered = File.createTempFile("PDFBox_streamu_", null, this.scratchFileDirectory);
            return new RandomAccessFile(this.scratchFileUnfiltered, "rw");
        }
        catch (IOException exception) {
            LOG.error((Object)"Can't create temp file, using memory buffer instead", (Throwable)exception);
            return new RandomAccessBuffer();
        }
    }

    public InputStream getFilteredStream() throws IOException {
        InputStream retval;
        if (this.getFilteredBuffer() != null && this.getFilteredBuffer().isClosed()) {
            throw new IOException("COSStream has been closed and cannot be read. Perhaps its enclosing PDDocument has been closed?");
        }
        if (this.filteredStream == null) {
            this.doEncode();
        }
        if (this.filteredStream != null) {
            long position = this.filteredStream.getPosition();
            long length = this.filteredStream.getLengthWritten();
            retval = new BufferedInputStream(new RandomAccessFileInputStream(this.getFilteredBuffer(), position, length), 16384);
        } else {
            retval = new ByteArrayInputStream(new byte[0]);
        }
        return retval;
    }

    public long getFilteredLength() throws IOException {
        if (this.filteredStream == null) {
            this.doEncode();
        }
        return this.filteredStream.getLength();
    }

    public InputStream getUnfilteredStream() throws IOException {
        InputStream retval;
        if (this.getUnfilteredBuffer() != null && this.getUnfilteredBuffer().isClosed()) {
            throw new IOException("COSStream has been closed and cannot be read. Perhaps its enclosing PDDocument has been closed?");
        }
        if (this.unFilteredStream == null) {
            this.doDecode();
        }
        if (this.unFilteredStream != null) {
            long position = this.unFilteredStream.getPosition();
            long length = this.unFilteredStream.getLengthWritten();
            retval = new BufferedInputStream(new RandomAccessFileInputStream(this.getUnfilteredBuffer(), position, length), 16384);
        } else {
            retval = new ByteArrayInputStream(new byte[0]);
        }
        return retval;
    }

    public DecodeResult getDecodeResult() throws IOException {
        if (this.unFilteredStream == null) {
            this.doDecode();
        }
        if (this.unFilteredStream == null || this.decodeResult == null) {
            StringBuilder filterInfo = new StringBuilder();
            COSBase filters = this.getFilters();
            if (filters != null) {
                filterInfo.append(" - filter: ");
                if (filters instanceof COSName) {
                    filterInfo.append(((COSName)filters).getName());
                } else if (filters instanceof COSArray) {
                    COSArray filterArray = (COSArray)filters;
                    for (int i = 0; i < filterArray.size(); ++i) {
                        if (filterArray.size() > 1) {
                            filterInfo.append(", ");
                        }
                        filterInfo.append(((COSName)filterArray.get(i)).getName());
                    }
                }
            }
            String subtype = this.getNameAsString(COSName.SUBTYPE);
            throw new IOException(subtype + " stream was not read" + filterInfo);
        }
        return this.decodeResult;
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws IOException {
        return visitor.visitFromStream(this);
    }

    private void doDecode() throws IOException {
        COSBase filters = this.getFilters();
        if (filters == null) {
            this.unFilteredStream = new RandomAccessFileOutputStream(this.getUnfilteredBuffer(true));
            IOUtils.copy(this.getFilteredStream(), this.unFilteredStream);
            this.decodeResult = DecodeResult.DEFAULT;
        } else if (filters instanceof COSName) {
            this.copyBuffer(this.getFilteredBuffer(false), this.filteredStream.getPosition());
            this.doDecode((COSName)filters, 0, this.getFilteredBuffer().length(), this.getUnfilteredBuffer(true));
        } else if (filters instanceof COSArray) {
            this.copyBuffer(this.getFilteredBuffer(false), this.filteredStream.getPosition());
            COSArray filterArray = (COSArray)filters;
            for (int i = 0; i < filterArray.size(); ++i) {
                COSName filterName = (COSName)filterArray.get(i);
                this.doDecode(filterName, i, this.getFilteredBuffer().length(), this.getUnfilteredBuffer(true));
                if (i >= filterArray.size()) continue;
                this.copyBuffer(this.getUnfilteredBuffer(false), 0L);
            }
            this.tempBuffer.close();
        } else {
            throw new IOException("Error: Unknown filter type:" + filters);
        }
    }

    private void copyBuffer(RandomAccess srcBuffer, long position) throws IOException {
        int length = (int)(srcBuffer.length() - position);
        byte[] byteBuffer = new byte[length];
        srcBuffer.seek(position);
        srcBuffer.read(byteBuffer, 0, length);
        if (this.tempBuffer == null) {
            this.tempBuffer = new RandomAccessBuffer();
        } else {
            this.tempBuffer.clear();
        }
        this.tempBuffer.write(byteBuffer, 0, length);
        this.tempBuffer.seek(0L);
    }

    private RandomAccess doDecode(COSName filterName, int filterIndex, long length, RandomAccess destBuffer) throws IOException {
        RandomAccess result = destBuffer;
        Filter filter = FilterFactory.INSTANCE.getFilter(filterName);
        if (length == 0L) {
            if (result == null) {
                result = this.createBuffer(false);
            }
        } else {
            result = this.attemptDecode(filter, filterIndex, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccess attemptDecode(Filter filter, int filterIndex, RandomAccess destBuffer) throws IOException {
        BufferedInputStream input = null;
        RandomAccess result = null;
        try {
            input = new BufferedInputStream(new RandomAccessFileInputStream(this.tempBuffer, 0L, this.tempBuffer.length()), 16384);
            IOUtils.closeQuietly(this.unFilteredStream);
            result = destBuffer == null ? this.createBuffer(false) : destBuffer;
            this.unFilteredStream = new RandomAccessFileOutputStream(result);
            this.decodeResult = filter.decode(input, this.unFilteredStream, this, filterIndex);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly(input);
        return result;
    }

    private void doEncode() throws IOException {
        COSBase filters = this.getFilters();
        if (filters == null) {
            this.filteredStream = new RandomAccessFileOutputStream(this.getFilteredBuffer(true));
            IOUtils.copy(this.getUnfilteredStream(), this.filteredStream);
        } else if (filters instanceof COSName) {
            this.copyBuffer(this.getUnfilteredBuffer(false), this.unFilteredStream.getPosition());
            this.doEncode((COSName)filters, 0, this.getFilteredBuffer(true));
        } else if (filters instanceof COSArray) {
            this.copyBuffer(this.getUnfilteredBuffer(false), this.unFilteredStream.getPosition());
            COSArray filterArray = (COSArray)filters;
            for (int i = filterArray.size() - 1; i >= 0; --i) {
                COSName filterName = (COSName)filterArray.get(i);
                this.doEncode(filterName, i, this.getFilteredBuffer(true));
                if (i < 0) continue;
                this.copyBuffer(this.getFilteredBuffer(false), 0L);
            }
            this.tempBuffer.close();
        }
    }

    private RandomAccess doEncode(COSName filterName, int filterIndex, RandomAccess destBuffer) throws IOException {
        RandomAccess result = null;
        Filter filter = FilterFactory.INSTANCE.getFilter(filterName);
        BufferedInputStream input = new BufferedInputStream(new RandomAccessFileInputStream(this.tempBuffer, 0L, this.tempBuffer.length()), 16384);
        IOUtils.closeQuietly(this.filteredStream);
        result = destBuffer == null ? this.createBuffer(true) : destBuffer;
        this.filteredStream = new RandomAccessFileOutputStream(result);
        filter.encode(input, this.filteredStream, this, filterIndex);
        IOUtils.closeQuietly(input);
        return result;
    }

    public COSBase getFilters() {
        return this.getDictionaryObject(COSName.FILTER);
    }

    public OutputStream createFilteredStream() throws IOException {
        IOUtils.closeQuietly(this.unFilteredStream);
        this.unFilteredStream = null;
        IOUtils.closeQuietly(this.filteredStream);
        this.filteredStream = new RandomAccessFileOutputStream(this.getFilteredBuffer(true));
        return new BufferedOutputStream(this.filteredStream, 16384);
    }

    public OutputStream createFilteredStream(COSBase expectedLength) throws IOException {
        OutputStream out = this.createFilteredStream();
        this.filteredStream.setExpectedLength(expectedLength);
        return out;
    }

    public void setFilters(COSBase filters) throws IOException {
        if (this.unFilteredStream == null) {
            this.doDecode();
        }
        this.setItem(COSName.FILTER, filters);
        IOUtils.closeQuietly(this.filteredStream);
        this.filteredStream = null;
    }

    public OutputStream createUnfilteredStream() throws IOException {
        IOUtils.closeQuietly(this.filteredStream);
        this.filteredStream = null;
        IOUtils.closeQuietly(this.unFilteredStream);
        this.unFilteredStream = new RandomAccessFileOutputStream(this.getUnfilteredBuffer(true));
        return new BufferedOutputStream(this.unFilteredStream, 16384);
    }

    private RandomAccess getFilteredBuffer() {
        return this.filteredBuffer;
    }

    private RandomAccess getFilteredBuffer(boolean clear) throws IOException {
        if (this.filteredBuffer == null) {
            this.filteredBuffer = this.createBuffer(true);
        } else if (clear) {
            this.filteredBuffer.clear();
        }
        return this.filteredBuffer;
    }

    private RandomAccess getUnfilteredBuffer() {
        return this.unfilteredBuffer;
    }

    private RandomAccess getUnfilteredBuffer(boolean clear) throws IOException {
        if (this.unfilteredBuffer == null) {
            this.unfilteredBuffer = this.createBuffer(false);
        } else if (clear) {
            this.unfilteredBuffer.clear();
        }
        return this.unfilteredBuffer;
    }

    @Override
    public void close() throws IOException {
        if (this.filteredStream != null) {
            this.filteredStream.close();
        }
        if (this.unFilteredStream != null) {
            this.unFilteredStream.close();
        }
        if (this.unfilteredBuffer != null) {
            this.unfilteredBuffer.close();
        }
        if (this.filteredBuffer != null) {
            this.filteredBuffer.close();
        }
        this.deleteFile(this.scratchFileFiltered);
        this.deleteFile(this.scratchFileUnfiltered);
    }

    private void deleteFile(File file) throws IOException {
        if (file != null && file.exists() && !file.delete()) {
            throw new IOException("Can't delete the temporary scratch file " + file.getAbsolutePath());
        }
    }
}

