/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.bzip2.Bzip2FileObject;
import org.apache.commons.vfs2.provider.tar.TarEntry;
import org.apache.commons.vfs2.provider.tar.TarFileObject;
import org.apache.commons.vfs2.provider.tar.TarFileProvider;
import org.apache.commons.vfs2.provider.tar.TarInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarFileSystem
extends AbstractFileSystem
implements FileSystem {
    private static final Log LOG = LogFactory.getLog(TarFileSystem.class);
    private final File file;
    private TarInputStream tarFile;

    protected TarFileSystem(AbstractFileName rootName, FileObject parentLayer, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super(rootName, parentLayer, fileSystemOptions);
        this.file = parentLayer.getFileSystem().replicateFile(parentLayer, Selectors.SELECT_SELF);
        if (!this.file.exists()) {
            this.tarFile = null;
            return;
        }
    }

    @Override
    public void init() throws FileSystemException {
        super.init();
        try {
            TarEntry entry;
            ArrayList<TarFileObject> strongRef = new ArrayList<TarFileObject>(100);
            while ((entry = this.getTarFile().getNextEntry()) != null) {
                TarFileObject fileObj;
                AbstractFileName name = (AbstractFileName)this.getFileSystemManager().resolveName(this.getRootName(), UriParser.encode(entry.getName()));
                if (entry.isDirectory() && this.getFileFromCache(name) != null) {
                    fileObj = (TarFileObject)this.getFileFromCache(name);
                    fileObj.setTarEntry(entry);
                    continue;
                }
                fileObj = this.createTarFileObject(name, entry);
                this.putFileToCache(fileObj);
                strongRef.add(fileObj);
                fileObj.holdObject(strongRef);
                TarFileObject parent = null;
                for (AbstractFileName parentName = (AbstractFileName)name.getParent(); parentName != null; parentName = (AbstractFileName)parentName.getParent()) {
                    parent = (TarFileObject)this.getFileFromCache(parentName);
                    if (parent == null) {
                        parent = this.createTarFileObject(parentName, null);
                        this.putFileToCache(parent);
                        strongRef.add(parent);
                        parent.holdObject(strongRef);
                    }
                    parent.attachChild(fileObj.getName());
                    fileObj = parent;
                }
            }
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
        finally {
            this.closeCommunicationLink();
        }
    }

    public InputStream getInputStream(TarEntry entry) throws FileSystemException {
        this.resetTarFile();
        try {
            while (!this.tarFile.getNextEntry().equals(entry)) {
            }
            return this.tarFile;
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
    }

    protected void resetTarFile() throws FileSystemException {
        if (this.file.exists()) {
            this.recreateTarFile();
        }
    }

    private void recreateTarFile() throws FileSystemException {
        TarInputStream tarFile;
        if (this.tarFile != null) {
            try {
                this.tarFile.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider.tar/close-tar-file.error", this.file, (Throwable)e);
            }
            this.tarFile = null;
        }
        this.tarFile = tarFile = this.createTarFile(this.file);
    }

    protected TarInputStream getTarFile() throws FileSystemException {
        if (this.tarFile == null && this.file.exists()) {
            this.recreateTarFile();
        }
        return this.tarFile;
    }

    protected TarFileObject createTarFileObject(AbstractFileName name, TarEntry entry) throws FileSystemException {
        return new TarFileObject(name, entry, this, true);
    }

    protected TarInputStream createTarFile(File file) throws FileSystemException {
        try {
            if ("tgz".equalsIgnoreCase(this.getRootName().getScheme())) {
                return new TarInputStream(new GZIPInputStream(new FileInputStream(file)));
            }
            if ("tbz2".equalsIgnoreCase(this.getRootName().getScheme())) {
                return new TarInputStream(Bzip2FileObject.wrapInputStream(file.getAbsolutePath(), new FileInputStream(file)));
            }
            return new TarInputStream(new FileInputStream(file));
        }
        catch (IOException ioe) {
            throw new FileSystemException("vfs.provider.tar/open-tar-file.error", file, (Throwable)ioe);
        }
    }

    @Override
    protected void doCloseCommunicationLink() {
        try {
            if (this.tarFile != null) {
                this.tarFile.close();
                this.tarFile = null;
            }
        }
        catch (IOException e) {
            VfsLog.warn(this.getLogger(), LOG, "vfs.provider.tar/close-tar-file.error :" + this.file, e);
        }
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(TarFileProvider.capabilities);
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new TarFileObject(name, null, this, false);
    }
}

