/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.extra.datatips;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.security.AccessControlException;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import org.nuiton.jaxx.widgets.extra.datatips.ListDataTipListener;
import org.nuiton.jaxx.widgets.extra.datatips.TableDataTipListener;
import org.nuiton.jaxx.widgets.extra.datatips.TreeDataTipListener;

public class DataTipManager {
    private static DataTipManager instance;
    private ListDataTipListener listMouseListener;
    private TableDataTipListener tableMouseListener;
    private TreeDataTipListener treeMouseListener;
    private Component parentComponent;
    private Window tipComponentWindow;
    private MouseEvent lastMouseEvent;
    private static boolean allowUntrustedUsage;

    private DataTipManager() {
        block2: {
            this.listMouseListener = new ListDataTipListener();
            this.tableMouseListener = new TableDataTipListener();
            this.treeMouseListener = new TreeDataTipListener();
            try {
                long eventMask = 131120L;
                Toolkit.getDefaultToolkit().addAWTEventListener(new MouseEventModifier(), eventMask);
            }
            catch (AccessControlException e) {
                if (allowUntrustedUsage) break block2;
                throw new RuntimeException("DataTipManager needs to run in a trusted application", e);
            }
        }
    }

    static void enableUntrustedUsage(boolean enable) {
        allowUntrustedUsage = enable;
    }

    public static synchronized DataTipManager get() {
        if (instance == null) {
            instance = new DataTipManager();
        }
        return instance;
    }

    public synchronized void register(JList list) {
        list.addMouseListener(this.listMouseListener);
        list.addMouseMotionListener(this.listMouseListener);
        list.addComponentListener(this.listMouseListener);
    }

    public synchronized void register(JTree tree) {
        tree.addMouseListener(this.treeMouseListener);
        tree.addMouseMotionListener(this.treeMouseListener);
        tree.addComponentListener(this.treeMouseListener);
    }

    public synchronized void register(JTable table) {
        table.addMouseListener(this.tableMouseListener);
        table.addMouseMotionListener(this.tableMouseListener);
        table.addComponentListener(this.tableMouseListener);
    }

    void setTipWindow(Component parentComponent, Window dataTipComponent) {
        this.parentComponent = parentComponent;
        this.tipComponentWindow = dataTipComponent;
    }

    public boolean handleEventFromParentComponent(MouseEvent mouseEvent) {
        Point point;
        if (mouseEvent == this.lastMouseEvent) {
            return false;
        }
        Object source = mouseEvent.getSource();
        if (source != this.parentComponent) {
            return false;
        }
        int id = mouseEvent.getID();
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        long when = mouseEvent.getWhen();
        int modifiers = mouseEvent.getModifiers();
        int clickCount = mouseEvent.getClickCount();
        boolean isPopupTrigger = mouseEvent.isPopupTrigger();
        if (id == 505 && this.tipComponentWindow.contains(point = SwingUtilities.convertPoint(this.parentComponent, x, y, this.tipComponentWindow))) {
            MouseEvent newEvent = new MouseEvent(this.parentComponent, 503, when, modifiers, x, y, clickCount, isPopupTrigger);
            this.parentComponent.dispatchEvent(newEvent);
            boolean stillVisible = this.parentComponent != null;
            return stillVisible;
        }
        return false;
    }

    public void handleEventFromDataTipComponent(MouseEvent mouseEvent) {
        mouseEvent.consume();
        int id = mouseEvent.getID();
        if (id != 504) {
            MouseEvent newEvent;
            int x = mouseEvent.getX();
            int y = mouseEvent.getY();
            Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), x, y, this.parentComponent);
            if (id == 505 && this.parentComponent.contains(point)) {
                return;
            }
            long when = mouseEvent.getWhen();
            int modifiers = mouseEvent.getModifiers();
            int clickCount = mouseEvent.getClickCount();
            boolean isPopupTrigger = mouseEvent.isPopupTrigger();
            if (id == 507) {
                MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)mouseEvent;
                int scrollType = mouseWheelEvent.getScrollType();
                int scrollAmount = mouseWheelEvent.getScrollAmount();
                int wheelRotation = mouseWheelEvent.getWheelRotation();
                newEvent = new MouseWheelEvent(this.parentComponent, id, when, modifiers, point.x, point.y, clickCount, isPopupTrigger, scrollType, scrollAmount, wheelRotation);
            } else {
                newEvent = new MouseEvent(this.parentComponent, id, when, modifiers, point.x, point.y, clickCount, isPopupTrigger);
            }
            Component parentComponentBackup = this.parentComponent;
            this.parentComponent.dispatchEvent(newEvent);
            if (this.parentComponent == null && id != 505) {
                MouseEvent exitEvent = new MouseEvent(parentComponentBackup, 505, when, modifiers, point.x, point.y, clickCount, isPopupTrigger);
                parentComponentBackup.dispatchEvent(exitEvent);
            }
            if (this.tipComponentWindow != null && id != 503) {
                this.tipComponentWindow.repaint();
            }
        }
    }

    private class MouseEventModifier
    implements AWTEventListener {
        private MouseEventModifier() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (DataTipManager.this.tipComponentWindow == null) {
                return;
            }
            Object source = event.getSource();
            if (source == DataTipManager.this.parentComponent) {
                MouseEvent mouseEvent = (MouseEvent)event;
                boolean filter = DataTipManager.this.handleEventFromParentComponent(mouseEvent);
                if (filter) {
                    mouseEvent.consume();
                } else {
                    DataTipManager.this.lastMouseEvent = mouseEvent;
                }
            }
        }
    }
}

