/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service;

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.MailFilter;
import com.franciaflex.faxtomail.persistence.entities.MailFilterTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.MailFolderTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;
import com.franciaflex.faxtomail.services.service.MailFolderService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.Address;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.Hibernate;
import org.nuiton.util.pagination.PaginationParameter;

public class MailFolderServiceImpl
extends FaxToMailServiceSupport
implements MailFolderService {
    @Override
    public MailFolder getFolderForRecipient(String recipient) {
        MailFilterTopiaDao filterTopiaDao = this.getPersistenceContext().getMailFilterDao();
        PaginationParameter tpb = PaginationParameter.of((int)0, (int)-1, (String)"position", (boolean)false);
        String query = "FROM " + MailFilter.class.getCanonicalName() + " WHERE :recipient LIKE " + "expression";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("recipient", recipient);
        List filters = filterTopiaDao.find(query, params, tpb);
        MailFolder result = CollectionUtils.isNotEmpty((Collection)filters) ? ((MailFilter)filters.iterator().next()).getMailFolder() : null;
        return result;
    }

    @Override
    public List<MailFilter> getFiltersForRecipient(String recipient) {
        MailFilterTopiaDao filterTopiaDao = this.getPersistenceContext().getMailFilterDao();
        PaginationParameter tpb = PaginationParameter.of((int)0, (int)-1, (String)"position", (boolean)false);
        String query = "FROM " + MailFilter.class.getCanonicalName() + " WHERE :recipient LIKE " + "expression";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("recipient", recipient);
        List filters = filterTopiaDao.find(query, params, tpb);
        return filters;
    }

    @Override
    public List<MailFolder> getAllMailFolders() {
        MailFolderTopiaDao dao = this.getPersistenceContext().getMailFolderDao();
        return new ArrayList<MailFolder>(dao.findAll());
    }

    @Override
    public List<MailFolder> getRootMailFolders() {
        MailFolderTopiaDao dao = this.getPersistenceContext().getMailFolderDao();
        List result = dao.forParentEquals(null).findAll();
        return result;
    }

    @Override
    public List<MailFolder> getRootMailFoldersWithReadingRights(FaxToMailUser user) {
        FaxToMailUser upToDateUser = this.serviceContext.getUserService().getUser(user.getTopiaId());
        user.setAffectedFolders(upToDateUser.getAffectedFolders());
        MailFolderTopiaDao dao = this.getPersistenceContext().getMailFolderDao();
        ArrayList folders = new ArrayList(dao.getReadableFolders(user));
        ArrayList<MailFolder> result = new ArrayList<MailFolder>(folders);
        Iterator i$ = folders.iterator();
        while (i$.hasNext()) {
            MailFolder folder;
            MailFolder f = folder = (MailFolder)i$.next();
            while (f.getParent() != null) {
                if (result.contains(f = f.getParent())) {
                    result.remove(folder);
                    folder = null;
                    break;
                }
                Hibernate.initialize((Object)f);
                f.setFolderReadable(false);
                f.setFolderWritable(false);
                this.fetchFolderAttributes(f);
            }
            if (folder == null) continue;
            this.browseReadableFolders(folder, user, false);
        }
        return result;
    }

    @Override
    public Set<MailFolder> getAllMailFoldersWithReadingRights(FaxToMailUser user) {
        MailFolderTopiaDao dao = this.getPersistenceContext().getMailFolderDao();
        return new HashSet<MailFolder>(dao.getReadableFolders(user, false));
    }

    protected void browseReadableFolders(MailFolder folder, FaxToMailUser user, boolean writable) {
        folder.setFolderReadable(true);
        if (!writable && folder.sizeWriteRightGroups() > 0) {
            writable = CollectionUtils.containsAny((Collection)folder.getWriteRightGroups(), (Collection)user.getUserGroups());
        }
        if (!writable && folder.sizeWriteRightUsers() > 0) {
            writable = folder.containsWriteRightUsers(user);
        }
        folder.setFolderWritable(writable);
        if (folder.isChildrenNotEmpty()) {
            for (MailFolder child : folder.getChildren()) {
                this.browseReadableFolders(child, user, writable);
            }
        }
        this.fetchFolderAttributes(folder);
    }

    @Override
    public List<MailFolder> getRootMailFoldersWithMoveRights(FaxToMailUser user) {
        MailFolderTopiaDao dao = this.getPersistenceContext().getMailFolderDao();
        ArrayList folders = new ArrayList(dao.getMoveableFolders(user));
        ArrayList<MailFolder> result = new ArrayList<MailFolder>(folders);
        Iterator i$ = folders.iterator();
        while (i$.hasNext()) {
            MailFolder folder;
            MailFolder f = folder = (MailFolder)i$.next();
            Boolean allowMoveDemandIntoFolder = folder.getAllowMoveDemandIntoFolder();
            while (f.getParent() != null) {
                if (result.contains(f = f.getParent())) {
                    result.remove(folder);
                    folder = null;
                    break;
                }
                this.fetchFolderAttributes(f);
                if (allowMoveDemandIntoFolder != null) continue;
                allowMoveDemandIntoFolder = f.getAllowMoveDemandIntoFolder();
            }
            if (folder == null) continue;
            this.browseMoveableFolders(folder, result, allowMoveDemandIntoFolder);
        }
        return result;
    }

    protected void browseMoveableFolders(MailFolder folder, List<MailFolder> readableRoots, boolean inheritedAllowMoveDemandIntoFolder) {
        Boolean allowMoveDemandIntoFolder = folder.getAllowMoveDemandIntoFolder();
        if (allowMoveDemandIntoFolder == null) {
            allowMoveDemandIntoFolder = inheritedAllowMoveDemandIntoFolder;
        } else {
            inheritedAllowMoveDemandIntoFolder = allowMoveDemandIntoFolder;
        }
        folder.setFolderMoveable(allowMoveDemandIntoFolder.booleanValue());
        if (folder.isChildrenNotEmpty()) {
            for (MailFolder child : folder.getChildren()) {
                readableRoots.remove(child);
                this.browseMoveableFolders(child, readableRoots, inheritedAllowMoveDemandIntoFolder);
            }
        }
        this.fetchFolderAttributes(folder);
    }

    protected void findMoveFolders(MailFolder folder, FaxToMailUser user, List<MailFolder> folders) {
        if (folder.containsMoveRightUsers(user) || !CollectionUtils.intersection((Iterable)folder.getMoveRightGroups(), (Iterable)user.getUserGroups()).isEmpty()) {
            folders.add(folder);
        } else if (folder.isChildrenNotEmpty()) {
            for (MailFolder child : folder.getChildren()) {
                this.findMoveFolders(child, user, folders);
            }
        }
    }

    @Override
    public void fetchFolderAttributes(MailFolder folder) {
        Hibernate.initialize((Object)folder.getChildren());
        Hibernate.initialize((Object)folder.getFolderTableColumns());
        Hibernate.initialize((Object)folder.getRanges());
        Hibernate.initialize((Object)folder.getReplyAddresses());
        Hibernate.initialize((Object)folder.getReplyDomains());
        if (folder.sizeWaitingStates() > 0) {
            for (WaitingState waitingState : folder.getWaitingStates()) {
                Hibernate.initialize((Object)waitingState.getInvalidFormDisabledActions());
                Hibernate.initialize((Object)waitingState.getValidFormDisabledActions());
            }
        }
        Hibernate.initialize((Object)folder.getDemandTypes());
    }

    @Override
    public List<MailFolder> getMailFolders(Collection<String> ids) {
        MailFolderTopiaDao dao = this.getPersistenceContext().getMailFolderDao();
        return new ArrayList<MailFolder>(dao.forTopiaIdIn(ids).findAll());
    }

    public Set<MailFolder> getFoldersWithWaitingState(Set<WaitingState> requiredWaitingStates) {
        HashSet<MailFolder> result = new HashSet<MailFolder>();
        MailFolderTopiaDao dao = this.getPersistenceContext().getMailFolderDao();
        List roots = dao.forParentEquals(null).findAll();
        for (MailFolder root : roots) {
            Collection<MailFolder> mailFolders = this.getFoldersWithWaitingState(root, new HashSet<WaitingState>(), requiredWaitingStates);
            result.addAll(mailFolders);
        }
        return result;
    }

    protected Collection<MailFolder> getFoldersWithWaitingState(MailFolder folder, Collection<WaitingState> parentWaitingState, Set<WaitingState> requiredWaitingStates) {
        Collection<WaitingState> waitingStates = folder.getWaitingStates();
        if (CollectionUtils.isEmpty((Collection)waitingStates)) {
            waitingStates = parentWaitingState;
        } else {
            parentWaitingState = waitingStates;
        }
        HashSet<MailFolder> result = new HashSet<MailFolder>();
        Collection children = folder.getChildren();
        if (children != null) {
            for (MailFolder child : children) {
                Collection<MailFolder> subMailFolders = this.getFoldersWithWaitingState(child, parentWaitingState, requiredWaitingStates);
                result.addAll(subMailFolders);
            }
        }
        if (CollectionUtils.isEmpty(waitingStates) || CollectionUtils.isEmpty(requiredWaitingStates) || waitingStates.containsAll(requiredWaitingStates)) {
            result.add(folder);
        }
        return result;
    }

    @Override
    public Map<String, Long> getMailFoldersUsage() {
        EmailTopiaDao dao = this.getPersistenceContext().getEmailDao();
        Map result = dao.getMailCountByFolder();
        return result;
    }

    @Override
    public MailFolder getFolderForFaxToMailUser(FaxToMailUser customerResponsible) {
        MailFolderTopiaDao dao = this.getPersistenceContext().getMailFolderDao();
        MailFolder result = (MailFolder)dao.forCustomerResponsiblesContains(customerResponsible).findAnyOrNull();
        return result;
    }

    @Override
    public MailFolder getMailFolder(String topiaId) {
        MailFolderTopiaDao dao = this.getPersistenceContext().getMailFolderDao();
        MailFolder result = (MailFolder)dao.forTopiaIdEquals(topiaId).findUnique();
        return result;
    }

    @Override
    public MailFilter findMailFilter(Email email, Set<String> modifiedProperties, List<Address> recipients) {
        MailFilter filter = null;
        for (Address address : recipients) {
            String recipient = address.toString();
            recipient = recipient.replaceFirst("^.*<(.*)>$", "$1");
            List<MailFilter> filters = this.getFiltersForRecipient(recipient = recipient.toLowerCase());
            if (!CollectionUtils.isNotEmpty(filters)) continue;
            MailFilter mailFilter = filters.get(0);
            if (filter != null && mailFilter.getPosition() >= filter.getPosition()) continue;
            filter = mailFilter;
            email.setRecipient(recipient);
            modifiedProperties.add("recipient");
        }
        return filter;
    }
}

