/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyImpl;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.ui.FieldExtension;
import org.nuiton.wikitty.ui.Model;
import org.nuiton.wikitty.ui.WikittyForm;
import org.nuiton.wikitty.ui.WikittyModel;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.util.GenericForwardComposer;
import org.zkoss.zul.Button;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Window;

public class WikittyController
extends GenericForwardComposer {
    protected Model _model = null;
    protected List<WikittyExtension> _extensions = new ArrayList();
    protected WikittyExtension _selectedExtension = null;
    protected WikittyExtension _selectedNewExtension;
    protected Listbox formListBox;
    protected WikittyForm _wikittyForm = new WikittyForm();
    protected Listbox wikittiesListBox;
    protected WikittyModel _wikittyModel = new WikittyModel();

    public WikittyController() {
        HttpSession Session2 = (HttpSession)Executions.getCurrent().getDesktop().getSession().getNativeSession();
        WikittyProxy proxy = (WikittyProxy)Session2.getAttribute("proxy");
        if (proxy != null) {
            this._model = new Model(proxy.getWikittyService());
            this._extensions = this._model.retrieveWikittyExtensions();
        } else {
            Executions.sendRedirect((String)"/");
        }
    }

    public void doAfterCompose(Component comp) throws Exception {
        super.doAfterCompose(comp);
        Window window = (Window)comp;
        Button add = (Button)window.getFellow("addNewInput");
        add.setDisabled(true);
        Button delete = (Button)window.getFellow("deleteInput");
        delete.setDisabled(true);
    }

    public void onClick$home() {
        Executions.sendRedirect((String)"/");
    }

    public void onOK$Search() {
        Textbox textbox = (Textbox)this.self.getFellow("Search");
        String search = textbox.getValue();
        if (search != null && !search.isEmpty()) {
            List wikitties = this._model.retrieveWikittiesByKeyword(search);
            this._wikittyModel.setWikitties(wikitties);
            this._selectedExtension = null;
        }
    }

    public void onClick$addNewInput() {
        this._wikittyForm.addNewInput(this.formListBox);
    }

    public void onClick$deleteInput() {
        this._wikittyForm.deleteInput(this.formListBox);
    }

    public void onClick$add() {
        Wikitty newWikitty = this._wikittyForm.retriveWikittyInForm(this.formListBox, (Wikitty)new WikittyImpl());
        this._model.create(newWikitty);
        if (this._selectedExtension != null) {
            List list = this._model.retrieveWikittiesByExtensionName(this._selectedExtension.getName());
            this._wikittyModel.setWikitties(list);
        } else {
            this.onOK$Search();
        }
    }

    public void onClick$update() {
        if (this._wikittyForm.isSelected()) {
            Wikitty newWikitty = this._wikittyForm.retriveWikittyInForm(this.formListBox, null);
            this._model.update(newWikitty);
        }
    }

    public void onClick$delete() {
        Set set = this.wikittiesListBox.getSelectedItems();
        ArrayList items = new ArrayList(set);
        for (Listitem item : items) {
            Wikitty wikitty = (Wikitty)item.getValue();
            this._model.deleteWikittyById(wikitty.getId());
            this._wikittyModel.removeData(wikitty);
        }
        this.wikittiesListBox.setSelectedIndex(0);
    }

    public void onClick$addNewExtension() {
        this._wikittyForm.addExtension(this._selectedNewExtension);
    }

    public void onSelect$formListBox() {
        Listitem item = this.formListBox.getSelectedItem();
        if (item != null) {
            FieldExtension fieldExtension = (FieldExtension)item.getValue();
            FieldType fieldType = fieldExtension.getFieldType();
            Button add = (Button)this.self.getFellow("addNewInput");
            Button delete = (Button)this.self.getFellow("deleteInput");
            if (!fieldType.isCollection()) {
                add.setDisabled(true);
                delete.setDisabled(true);
            } else {
                add.setDisabled(false);
                delete.setDisabled(false);
            }
        }
    }

    public ListitemRenderer getWikittyRenderer() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public List<WikittyExtension> getExtensions() {
        return this._extensions;
    }

    public WikittyExtension getSelectedExtension() {
        return this._selectedExtension;
    }

    public WikittyExtension getSelectedNewExtension() {
        return this._selectedNewExtension;
    }

    public WikittyForm getWikittyForm() {
        return this._wikittyForm;
    }

    public ListModel getWikittyModel() {
        return this._wikittyModel;
    }

    public Wikitty getSelectedWikitty() {
        return this._wikittyForm.getWikitty();
    }

    public void setSelectedExtension(WikittyExtension current) {
        this._selectedExtension = current;
        this._wikittyForm.setHoldExtensions(current);
        List list = this._model.retrieveWikittiesByExtensionName(current.getName());
        this._wikittyModel.setWikitties(list);
        Window window = (Window)this.self;
        Button add = (Button)window.getFellow("addNewInput");
        add.setDisabled(true);
        Button delete = (Button)window.getFellow("deleteInput");
        delete.setDisabled(true);
    }

    public void setSelectedNewExtension(WikittyExtension current) {
        this._selectedNewExtension = current;
    }

    public void setSelectedWikitty(Wikitty current) {
        this._wikittyForm.setWikitty(current);
    }

    protected String getToolTipsByExtension(String extension, Wikitty wikitty) {
        String toolTip = "";
        WikittyExtension wikittyExtension = wikitty.getExtension(extension);
        Collection fieldNames = wikittyExtension.getFieldNames();
        for (String fieldName : fieldNames) {
            String result = wikitty.getFieldAsString(extension, fieldName);
            if (result == null) {
                result = "";
            }
            if (result.length() > 50) {
                result = result.substring(0, 46);
                result = wikittyExtension.getFieldType(fieldName).isCollection() ? result + "...]" : result + "...";
            }
            toolTip = toolTip + fieldName + " : " + result + "\n";
        }
        return toolTip;
    }
}

