/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.struts.component;

import com.opensymphony.xwork2.util.ValueStack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.views.annotations.StrutsTag;
import org.nuiton.wikitty.struts.TagUseException;
import org.nuiton.wikitty.struts.WikittyFieldHandler;
import org.nuiton.wikitty.struts.component.AbstractWikittyComponent;

@StrutsTag(name="Wikitty", tldTagClass="org.nuiton.wikitty.struts.tag.FormTag", description="", allowDynamicAttributes=false)
public class FormTagBean
extends AbstractWikittyComponent {
    private static final Log log = LogFactory.getLog(FormTagBean.class);
    public static final String OPEN_TEMPLATE = "ws-form";
    public static final String TEMPLATE = "ws-form-close";
    protected String action;
    protected String redirect;
    protected String include;
    protected String exclude;
    protected String order;
    protected Boolean orderBefore;
    protected Boolean allowDelete;

    public FormTagBean(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    @Override
    protected void evaluateExtraParams() {
        WikittyFieldHandler handler;
        super.evaluateExtraParams();
        if (this.wikitty == null && this.businessEntity == null) {
            log.info((Object)"wikitty and businessEntity not declared");
            throw new TagUseException("Tag must declare a valid Wikitty or businessEntity attribute");
        }
        if (this.include.length() != 0 && !this.include.matches(REGEX_LIST_FQFIELDNAME)) {
            log.debug((Object)("Include list set: " + this.include + " expected match: " + REGEX_WIKITTY_FQFIELDNAME));
            throw new TagUseException("Include list field must be set with correct value: " + REGEX_LIST_FQFIELDNAME);
        }
        if (this.order.length() != 0 && !this.order.matches(REGEX_LIST_FQFIELDNAME)) {
            log.debug((Object)("Order list set: " + this.order + " expected match: " + REGEX_WIKITTY_FQFIELDNAME));
            throw new TagUseException("Order list field must be set with correct value: " + REGEX_LIST_FQFIELDNAME);
        }
        if (this.exclude.length() != 0 && !this.exclude.matches(REGEX_LIST_FQFIELDNAME)) {
            log.debug((Object)("Exclude list set: " + this.exclude + " expected match: " + REGEX_WIKITTY_FQFIELDNAME));
            throw new TagUseException("Exclude list field must be set with correct value: " + REGEX_LIST_FQFIELDNAME);
        }
        if (this.action != null) {
            this.addParameter("action", this.findString(this.action));
        }
        if (this.redirect != null) {
            this.addParameter("redirect", this.findString(this.redirect));
        }
        if (this.allowDelete != null) {
            this.addParameter("allowDelete", this.allowDelete);
        }
        if (this.orderBefore != null) {
            this.addParameter("orderBefore", this.orderBefore);
        }
        if (this.name == null || this.name.equals("")) {
            this.name = "wikitty-form-" + this.getWikitty().getId();
        }
        this.addParameter("wikittyid", this.findString(this.getWikitty().getId()));
        this.addParameter("name", this.name);
        Object temp = this.stack.getContext().get("wikitty_key");
        if (temp == null) {
            handler = new WikittyFieldHandler();
            log.info((Object)(handler + " Added to the stack"));
            this.stack.getContext().put("wikitty_key", handler);
            handler.setExclude(this.exclude);
            handler.setInclude(this.include);
            handler.setOrder(this.order);
            handler.setWikitty(this.getWikitty());
            handler.setProxy(this.proxy);
            handler.setOrderBefore(this.orderBefore);
        } else {
            this.stack.getContext().remove("wikitty_key");
            handler = (WikittyFieldHandler)temp;
        }
        log.info((Object)"add wikitty fields to the parametters");
        this.addParameter("wikittyfields", handler.getWikittyField());
    }

    public String getDefaultOpenTemplate() {
        return OPEN_TEMPLATE;
    }

    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include.trim();
    }

    public String getExclude() {
        return this.exclude;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude.trim();
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order.trim();
    }

    public boolean isAllowDelete() {
        return this.allowDelete;
    }

    public void setAllowDelete(boolean allowDelete) {
        this.allowDelete = allowDelete;
    }

    public Boolean getOrderBefore() {
        return this.orderBefore;
    }

    public void setOrderBefore(Boolean orderBefore) {
        this.orderBefore = orderBefore;
    }

    public Boolean getAllowDelete() {
        return this.allowDelete;
    }

    public void setAllowDelete(Boolean allowDelete) {
        this.allowDelete = allowDelete;
    }
}

