/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.struts.component;

import com.opensymphony.xwork2.util.ValueStack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.struts.TagUseException;
import org.nuiton.wikitty.struts.WikittyFieldHandler;
import org.nuiton.wikitty.struts.component.AbstractWikittyComponent;

public abstract class AbstractWikittyComponentBean
extends AbstractWikittyComponent {
    private static final Log log = LogFactory.getLog(AbstractWikittyComponentBean.class);
    protected WikittyFieldHandler handler;
    protected String fqFieldName;

    protected AbstractWikittyComponentBean(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
        this.handler = (WikittyFieldHandler)stack.getContext().get("wikitty_key");
    }

    public boolean isIncluded(String fieldName) {
        if (this.handler != null) {
            return this.handler.isIncluded(fieldName);
        }
        return true;
    }

    @Override
    public WikittyProxy getProxy() {
        if (this.handler != null) {
            return this.handler.getProxy();
        }
        return super.getProxy();
    }

    @Override
    public Wikitty getWikitty() {
        if (this.handler != null) {
            return this.handler.getWikitty();
        }
        return super.getWikitty();
    }

    @Override
    public BusinessEntity getBusinessEntity() {
        if (this.handler != null) {
            return this.handler.getBusinessEntity();
        }
        return super.getBusinessEntity();
    }

    @Override
    public String getWikittyId() {
        if (this.handler != null) {
            return this.handler.getWikittyId();
        }
        return super.getWikittyId();
    }

    @Override
    protected void evaluateExtraParams() {
        super.evaluateExtraParams();
        if (this.handler == null && this.wikitty == null && this.businessEntity == null && this.wikittyId == null) {
            log.info((Object)"Handler not found in the stack and wikittyId, wikitty or businessEntity not declared");
            throw new TagUseException("Tag must declare wikittyId, Wikitty or businessEntity attribute if used outside ws:form tag");
        }
        if (!this.fqFieldName.matches(REGEX_WIKITTY_FQFIELDNAME)) {
            log.debug((Object)("fqFieldName: " + this.fqFieldName + " expected match" + REGEX_WIKITTY_FQFIELDNAME));
            throw new TagUseException("fqFieldName must be valid: " + REGEX_WIKITTY_FQFIELDNAME);
        }
        if (this.name != null && this.handler == null) {
            this.addParameter("name", this.name);
        } else {
            this.addParameter("name", this.fqFieldName);
        }
        if (this.isIncluded(this.fqFieldName)) {
            this.addParameter("included", true);
            if (this.handler != null) {
                this.handler.addAddedField(this.fqFieldName);
            }
        }
    }

    public WikittyFieldHandler getHandler() {
        return this.handler;
    }

    public void setHandler(WikittyFieldHandler handler) {
        this.handler = handler;
    }

    public String getFqFieldName() {
        return this.fqFieldName;
    }

    public void setFqFieldName(String fqFieldName) {
        this.fqFieldName = fqFieldName.trim();
    }
}

