/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.jdbc.WikittyManagedDataSource;
import org.nuiton.wikitty.services.WikittyTransaction;

public class WikittyJDBCUtil {
    private static Log log = LogFactory.getLog(WikittyJDBCUtil.class);
    public static final String[] BINARY_TYPES = new String[]{"bytea", "blob"};
    public static final String COL_EXTENSION = "extension_list";
    public static final String COL_VERSION = "version";
    public static final String COL_ID = "id";
    public static final String COL_NAME = "name";
    public static final String COL_REQUIRES = "requires";
    public static final String COL_TAGVALUES = "tagvalues";
    public static final String COL_FIELDNAME = "fieldName";
    public static final String COL_FIELDTYPE = "fieldType";
    public static final String COL_BINARY_VALUE = "binaryValue";
    public static final String COL_BOOLEAN_VALUE = "booleanValue";
    public static final String COL_NUMBER_VALUE = "numberValue";
    public static final String COL_TEXT_VALUE = "textValue";
    public static final String COL_DATE_VALUE = "dateValue";
    public static final String COL_DELETION_DATE = "deletionDate";
    public static final String QUERY_SELECT = "jdbc.queries.select";
    public static final String QUERY_SELECT_NOTDELETED = "jdbc.queries.select.notdeleted";
    public static final String QUERY_COUNT_ACTIVE_WIKITTY = "jdbc.queries.select.count.active.wikitties";
    public static final String QUERY_COUNT_DELETED_WIKITTY = "jdbc.queries.select.count.deleted.wikitties";
    public static final String QUERY_SELECT_WHERE = "jdbc.queries.select.where";
    public static final String QUERY_SELECT_TWO_WHERE = "jdbc.queries.select.two.where";
    public static final String QUERY_SELECT_WHERE_REQUIRES = "jdbc.queries.select.requires";
    public static final String QUERY_SELECT_WHERE_NOTDELETED = "jdbc.queries.select.where.notdeleted";
    public static final String QUERY_CREATION_WIKITTY_ADMIN = "jdbc.queries.creation.wikitty.admin";
    public static final String QUERY_CREATION_WIKITTY_DATA_TEST_BINARY = "jdbc.queries.creation.wikitty.data.test.binary";
    public static final String QUERY_CREATION_WIKITTY_DATA_ALTER_BINARY = "jdbc.queries.creation.wikitty.data.alter.binary";
    public static final String QUERY_CREATION_WIKITTY_DATA = "jdbc.queries.creation.wikitty.data";
    public static final String QUERY_CREATION_WIKITTY_DATA_NO_BINARY = "jdbc.queries.creation.wikitty.data.no.binary";
    public static final String QUERY_INSERT_WIKITTY_ADMIN = "jdbc.queries.insert.wikitty.admin";
    public static final String QUERY_UPDATE_WIKITTY_ADMIN = "jdbc.queries.update.wikitty.admin";
    public static final String QUERY_INSERT_WIKITTY_DATA = "jdbc.queries.insert.wikitty.data";
    public static final String QUERY_DELETE_WIKITTY_ADMIN = "jdbc.queries.delete.wikitty.admin";
    public static final String QUERY_DELETE_WIKITTY_DATA = "jdbc.queries.delete.wikitty.data";
    public static final String QUERY_CLEAR_EXTENSION = "jdbc.queries.clear.extension";
    public static final String QUERY_CLEAR_WIKITTY = "jdbc.queries.clear.wikitty";
    public static final String QUERY_SELECT_EXTENSION_ADMIN = "jdbc.queries.select.extension.admin";
    public static final String QUERY_DELETE_EXTENSION_ADMIN = "jdbc.queries.delete.extension.admin";
    public static final String QUERY_DELETE_EXTENSION_DATA = "jdbc.queries.delete.extension.data";
    public static final String QUERY_CREATION_EXTENSION_ADMIN = "jdbc.queries.creation.extension.admin";
    public static final String QUERY_CREATION_EXTENSION_DATA = "jdbc.queries.creation.extension.data";
    public static final String QUERY_INSERT_EXTENSION_ADMIN = "jdbc.queries.insert.extension.admin";
    public static final String QUERY_INSERT_EXTENSION_DATA = "jdbc.queries.insert.extension.data";
    protected static String TABLE_WIKITTY_ADMIN = "wikitty_admin";
    protected static String TABLE_WIKITTY_DATA = "wikitty_data";
    protected static String TABLE_EXTENSION_ADMIN = "extension_admin";
    protected static String TABLE_EXTENSION_DATA = "extension_data";
    private static Map<String, WikittyManagedDataSource> dataSources = new HashMap<String, WikittyManagedDataSource>();

    public static synchronized Properties loadQuery(ApplicationConfig config) {
        Properties result = null;
        List wikittyQueryFiles = config.getOptionAsList(WikittyConfigOption.WIKITTY_STORAGE_JDBC_QUERY_FILE.getKey()).getOption();
        for (String file : wikittyQueryFiles) {
            result = new Properties(result);
            InputStream streamQuery = null;
            try {
                URL url = ClassLoader.getSystemResource(file);
                if (url == null) {
                    ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                    url = contextClassLoader.getResource(file);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Reading resource from: " + url));
                }
                streamQuery = url.openStream();
                result.load(streamQuery);
            }
            catch (IOException eee) {
                try {
                    throw new WikittyException(String.format("Unable to load property file '%s'", file), (Throwable)eee);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(streamQuery);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)streamQuery);
        }
        return result;
    }

    public static synchronized Connection getConnectionUnconfigured(WikittyTransaction tx, ApplicationConfig conf) {
        if (tx == null) {
            throw new IllegalArgumentException("WikittyTransaction must not be null");
        }
        String driver = conf.getOption(WikittyConfigOption.WIKITTY_STORAGE_JDBC_DRIVER.getKey());
        String host = conf.getOption(WikittyConfigOption.WIKITTY_STORAGE_JDBC_URL.getKey());
        String username = conf.getOption(WikittyConfigOption.WIKITTY_STORAGE_JDBC_LOGIN.getKey());
        String password = conf.getOption(WikittyConfigOption.WIKITTY_STORAGE_JDBC_PASSWORD.getKey());
        String xaDataSourceClassName = conf.getOption(WikittyConfigOption.WIKITTY_STORAGE_JDBC_XADATASOURCE.getKey());
        try {
            WikittyManagedDataSource dataSource;
            String jdbcUrl = String.format("%s:%s@%s", username, password, host);
            if (!dataSources.containsKey(jdbcUrl)) {
                if (log.isInfoEnabled()) {
                    String jdbcUrlForLog = String.format("%s:%s@%s", username, "********", host);
                    log.info((Object)("Creating BasicManagedDataSource for: " + jdbcUrlForLog));
                }
                dataSource = new WikittyManagedDataSource();
                if (StringUtils.isNotEmpty((String)xaDataSourceClassName)) {
                    XADataSource xaDataSource = (XADataSource)Class.forName(xaDataSourceClassName).newInstance();
                    BeanMap beanMap = new BeanMap((Object)xaDataSource);
                    Set fields = beanMap.keySet();
                    String keyStart = WikittyConfigOption.WIKITTY_STORAGE_JDBC_XADATASOURCE.getKey() + "." + xaDataSourceClassName + ".";
                    for (Map.Entry<Object, Object> properties : conf.getFlatOptions().entrySet()) {
                        String propertyName = (String)properties.getKey();
                        if (!propertyName.startsWith(keyStart)) continue;
                        if (fields.contains(propertyName = propertyName.replaceFirst(keyStart, ""))) {
                            String propertyValue = (String)properties.getValue();
                            BeanUtils.setProperty((Object)xaDataSource, (String)propertyName, (Object)propertyValue);
                            continue;
                        }
                        log.warn((Object)("Invalid property " + propertyName + " for XADatasource " + Arrays.toString(fields.toArray())));
                    }
                    dataSource.setXaDataSourceInstance(xaDataSource);
                } else {
                    log.warn((Object)"No xadatasource is used, data integrity is not guarantee");
                }
                dataSource.setDriverClassName(driver);
                dataSource.setUrl(host);
                dataSource.setUsername(username);
                dataSource.setPassword(password);
                TransactionManager tm = tx.getTransactionManager();
                dataSource.setTransactionManager(tm);
                dataSources.put(jdbcUrl, dataSource);
            }
            dataSource = dataSources.get(jdbcUrl);
            Connection connection = dataSource.getConnection();
            return connection;
        }
        catch (Exception eee) {
            String msg = String.format("Can't connect to database %s %s with login %s", driver, host, username);
            log.error((Object)msg, (Throwable)eee);
            throw new WikittyException(msg, (Throwable)eee);
        }
    }

    public static void closeQuietly(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception while closing connection", (Throwable)e);
        }
    }

    public static synchronized Connection getConnection(WikittyTransaction tx, ApplicationConfig config) {
        try {
            Connection connection = WikittyJDBCUtil.getConnectionUnconfigured(tx, config);
            if (connection.getAutoCommit()) {
                connection.setAutoCommit(false);
            }
            return connection;
        }
        catch (SQLException eee) {
            throw new WikittyException("Can't set connection auto commit to false", (Throwable)eee);
        }
    }

    public static boolean tableExist(Connection connection, String tableName) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        boolean existInLowerCase = metaData.getTables(null, null, tableName, null).next();
        boolean existInUpperCase = metaData.getTables(null, null, tableName.toUpperCase(), null).next();
        return existInLowerCase || existInUpperCase;
    }

    public static String getSupportedBinaryType(Connection connection) throws SQLException {
        ResultSet typeInfo = connection.getMetaData().getTypeInfo();
        while (typeInfo.next()) {
            String type = typeInfo.getString("TYPE_NAME");
            if (!ArrayUtils.contains((Object[])BINARY_TYPES, (Object)type.toLowerCase())) continue;
            return type;
        }
        return null;
    }

    public static void doQuery(Connection connection, String query, Object ... args) throws SQLException {
        PreparedStatement sta = connection.prepareStatement(query);
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Date) {
                sta.setObject(i + 1, args[i], 93);
                continue;
            }
            sta.setObject(i + 1, args[i]);
        }
        sta.execute();
    }
}

