/*
 * #%L
 * Wikitty :: hessian server
 * 
 * $Id: WikittyServerStart.java 650 2010-12-23 11:44:57Z sletellier $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.0.1/wikitty-hessian-server/src/main/java/org/nuiton/wikitty/WikittyServerStart.java $
 * %%
 * Copyright (C) 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Read wikitty config file and create WikittyService as asked in config.
 * WikittyServiceHessianServer must be declared in config file otherwize server
 * don't start
 *
 * @author poussin
 * @version $Revision: 650 $
 *
 * Last update: $Date: 2010-12-23 12:44:57 +0100 (jeu., 23 déc. 2010) $
 * by : $Author: sletellier $
 */
public class WikittyServerStart {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(WikittyServerStart.class);

    static public void main(String ... args) {
        WikittyConfig config = new WikittyConfig(args);
        WikittyService ws = WikittyServiceFactory.buildWikittyService(config);
    }

}
