/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.services.WikittyCache;

public class WikittyCacheSimple
implements WikittyCache {
    private static Log log = LogFactory.getLog(WikittyCacheSimple.class);
    protected Set<String> priorityExtensions = new HashSet<String>();
    protected Map<String, Wikitty> priorityCache = new HashMap<String, Wikitty>();
    protected Map<String, Wikitty> wikittyCache;
    protected Map<String, WikittyExtension> extensionCache;

    public WikittyCacheSimple(ApplicationConfig config) {
        List priorityExtensions = config.getOptionAsList(WikittyConfigOption.WIKITTY_CACHE_PRIORITY_EXTENSIONS.getKey()).getOption();
        this.priorityExtensions.addAll(priorityExtensions);
        String refType = config.getOption(WikittyConfigOption.WIKITTY_CACHE_SIMPLE_REFERENCE_TYPE.getKey());
        if ("soft".equalsIgnoreCase(refType)) {
            this.wikittyCache = new ReferenceMap(0, 1);
            this.extensionCache = new ReferenceMap(0, 1);
        } else {
            this.wikittyCache = new HashMap<String, Wikitty>();
            this.extensionCache = new HashMap<String, WikittyExtension>();
        }
    }

    @Override
    public boolean existsWikitty(String id) {
        boolean result;
        Wikitty o = this.priorityCache.get(id);
        boolean bl = result = o != null;
        if (!result) {
            o = this.wikittyCache.get(id);
            result = o != null;
        }
        return result;
    }

    @Override
    public Wikitty getWikitty(String id) {
        Wikitty result = this.priorityCache.get(id);
        if (result == null) {
            result = this.wikittyCache.get(id);
        }
        return result;
    }

    @Override
    public void putWikitty(Wikitty e) {
        if (e != null) {
            if (Collections.disjoint(this.priorityExtensions, e.getExtensionNames())) {
                this.wikittyCache.put(e.getWikittyId(), e);
            } else {
                this.priorityCache.put(e.getWikittyId(), e);
            }
        }
    }

    @Override
    public void removeWikitty(String id) {
        this.priorityCache.remove(id);
        this.wikittyCache.remove(id);
    }

    @Override
    public void clearWikitty() {
        this.priorityCache.clear();
        this.wikittyCache.clear();
    }

    @Override
    public boolean existsExtension(String id) {
        WikittyExtension o = this.extensionCache.get(id);
        boolean result = o != null;
        return result;
    }

    @Override
    public WikittyExtension getExtension(String id) {
        WikittyExtension result = this.extensionCache.get(id);
        return result;
    }

    @Override
    public void putExtension(WikittyExtension e) {
        if (e != null) {
            this.extensionCache.put(e.getId(), e);
        }
    }

    @Override
    public void removeExtension(String id) {
        this.extensionCache.remove(id);
    }

    @Override
    public void clearExtension() {
        this.extensionCache.clear();
    }
}

