/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.TimeLog;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyUserHelper;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.services.WikittyServiceAuthenticationAbstract;
import org.nuiton.wikitty.services.WikittyServiceEnhanced;

public class WikittyServiceAuthentication
extends WikittyServiceAuthenticationAbstract {
    private static Log log = LogFactory.getLog(WikittyServiceAuthentication.class);
    private static final TimeLog timeLog = new TimeLog(WikittyServiceAuthentication.class);

    public WikittyServiceAuthentication(ApplicationConfig config, WikittyService ws) {
        super(config, ws);
        if (config != null) {
            long timeToLogInfo = config.getOptionAsInt(WikittyConfigOption.WIKITTY_SERVICE_TIME_TO_LOG_INFO.getKey());
            long timeToLogWarn = config.getOptionAsInt(WikittyConfigOption.WIKITTY_SERVICE_TIME_TO_LOG_WARN.getKey());
            timeLog.setTimeToLogInfo(timeToLogInfo);
            timeLog.setTimeToLogWarn(timeToLogWarn);
        }
    }

    @Override
    public String login(String login, String password) {
        long start = TimeLog.getTime();
        if (StringUtils.isBlank((CharSequence)login)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("User try to authenticate with bad blank login: '%s'", login));
            }
            throw new SecurityException("bad login or password");
        }
        WikittyQuery criteria = new WikittyQueryMaker().eq("WikittyUser.login", (Object)login).end();
        String userId = this.getDelegate().findByQuery(null, Collections.singletonList(criteria)).get(0);
        if (userId == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("User try to authenticate with bad login: '%s'", login));
            }
            throw new SecurityException("bad login or password");
        }
        Wikitty user = WikittyServiceEnhanced.restore(this.getDelegate(), null, userId);
        if (!StringUtils.equals((CharSequence)WikittyUserHelper.getPassword(user), (CharSequence)password)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("User '%s' try to authenticate with bad password", login));
            }
            throw new SecurityException("bad login or password");
        }
        String tokenId = this.getToken(user);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("User logged: '%s'", login));
        }
        timeLog.log(start, "login");
        return tokenId;
    }
}

