/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.entities;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ObjectUtil;
import org.nuiton.util.VersionUtil;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyCopyOnWrite;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTypes;

public class WikittyImpl
implements Wikitty {
    private static Log log = LogFactory.getLog(WikittyImpl.class);
    private static final long serialVersionUID = 4910886672760691052L;
    protected String id;
    protected String version = "0.0";
    protected Date deleteDate = null;
    private transient PropertyChangeSupport propertyChange;
    protected HashMap<String, Object> fieldValue = new HashMap();
    protected Set<String> fieldDirty = new HashSet<String>();
    protected Map<String, WikittyExtension> extensions = new LinkedHashMap<String, WikittyExtension>();
    protected String preloadPattern;
    protected Map<String, Wikitty> preloaded;

    public WikittyImpl() {
        this(null);
    }

    public WikittyImpl(String id) {
        this.id = id == null ? WikittyUtil.genUID() : id;
    }

    @Override
    public String getPreloadPattern() {
        return this.preloadPattern;
    }

    @Override
    public void setPreloadPattern(String preloadPattern) {
        this.preloadPattern = preloadPattern;
    }

    @Override
    public Set<String> getAllPreloadPattern() {
        HashSet<String> result = new HashSet<String>();
        String[] preloadPatterns = StringUtils.split((String)this.getPreloadPattern(), (String)";");
        if (preloadPatterns != null) {
            result.addAll(Arrays.asList(preloadPatterns));
        }
        for (WikittyExtension ext : this.getExtensions()) {
            preloadPatterns = StringUtils.split((String)ext.getTagValue("preload"), (String)";");
            if (preloadPatterns == null) continue;
            result.addAll(Arrays.asList(preloadPatterns));
        }
        result.remove(null);
        return result;
    }

    @Override
    public Map<String, Wikitty> getPreloaded() {
        if (this.preloaded == null) {
            this.preloaded = new HashMap<String, Wikitty>();
        }
        return Collections.unmodifiableMap(this.preloaded);
    }

    @Override
    public void setPreloaded(Map<String, Wikitty> preloaded) {
        HashMap<String, Wikitty> map = new HashMap<String, Wikitty>();
        if (preloaded != null) {
            map.putAll(preloaded);
        }
        this.preloaded = map;
    }

    @Override
    public void addPreloaded(Wikitty w) {
        if (w != null) {
            if (this.preloaded == null) {
                this.preloaded = new HashMap<String, Wikitty>();
            }
            this.preloaded.put(w.getWikittyId(), w);
        }
    }

    @Override
    public void replaceWith(Wikitty w) {
        this.replaceWith(w, false);
    }

    @Override
    public void replaceWith(Wikitty w, boolean force) {
        if (this == w) {
            return;
        }
        if (w instanceof WikittyCopyOnWrite) {
            this.replaceWith(((WikittyCopyOnWrite)w).getTarget(), force);
        } else if (force || this.getWikittyId().equals(w.getWikittyId())) {
            this.setPreloaded(w.getPreloaded());
            this.setPreloadPattern(w.getPreloadPattern());
            this.extensions.clear();
            this.fieldValue.clear();
            for (WikittyExtension ext : w.getExtensions()) {
                String extName = ext.getName();
                this.extensions.put(extName, ext);
                for (String fieldName : ext.getFieldNames()) {
                    Object value = w.getFieldAsObject(extName, fieldName);
                    if (value == null) continue;
                    if (value instanceof Collection && value instanceof Cloneable) {
                        try {
                            value = ObjectUtil.clone((Cloneable)((Cloneable)value));
                        }
                        catch (CloneNotSupportedException eee) {
                            throw new WikittyException(String.format("Can't copy field %s.%s", ext.getName(), fieldName), eee);
                        }
                    }
                    this.setField(extName, fieldName, value);
                }
            }
            if (!force) {
                this.version = w.getWikittyVersion();
                this.deleteDate = w.getDeleteDate();
            }
            this.clearDirty();
        } else {
            throw new IllegalArgumentException("Wikitty in argument don't have same id");
        }
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChange == null) {
            this.propertyChange = new PropertyChangeSupport(this);
        }
        return this.propertyChange;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getWikittyId() {
        return this.id;
    }

    @Override
    public boolean isDeleted() {
        boolean result = this.deleteDate != null;
        return result;
    }

    @Override
    public Date getDeleteDate() {
        return this.deleteDate;
    }

    @Override
    public void setDeleteDate(Date delete) {
        this.deleteDate = delete;
    }

    protected void setFieldDirty(String ext, String fieldName, Object oldValue, Object newValue) {
        String key = ext + "." + fieldName;
        this.fieldDirty.add(key);
        this.version = WikittyUtil.incrementMinorRevision(this.version);
        this.getPropertyChangeSupport().firePropertyChange(key, oldValue, newValue);
    }

    @Override
    public void addExtension(WikittyExtension ext) {
        WikittyExtension currentExt = this.extensions.get(ext.getName());
        if (currentExt != null && VersionUtil.greaterThan((String)currentExt.getVersion(), (String)ext.getVersion())) {
            throw new WikittyException(String.format("You try to put extension '%s' in older version (%s) than current version (%s). You must update your software.", ext.getName(), ext.getVersion(), currentExt.getVersion()));
        }
        List<String> required = ext.getRequires();
        if (required != null && !required.isEmpty() && !this.extensions.keySet().containsAll(required)) {
            throw new WikittyException(String.format("You try to add extension '%s' that required not available extension '%s' in this wikitty", ext.getName(), required));
        }
        this.extensions.put(ext.name, ext);
    }

    @Override
    public boolean hasMetaExtension(String metaExtensionName, String extensionName) {
        String metaExtensionFQName = WikittyUtil.getFQMetaExtensionName(metaExtensionName, extensionName);
        boolean hasMetaExtension = this.extensions.containsKey(metaExtensionFQName);
        return hasMetaExtension;
    }

    @Override
    public void addMetaExtension(WikittyExtension metaExtension, WikittyExtension extension) {
        this.addMetaExtension(metaExtension, extension.getName());
    }

    @Override
    public void addMetaExtension(WikittyExtension metaExtension, String extensionName) {
        if (!this.hasExtension(extensionName)) {
            throw new IllegalArgumentException("this wikitty doesn't have an extension named " + extensionName);
        }
        String metaExtensionFQName = WikittyUtil.getFQMetaExtensionName(metaExtension.getName(), extensionName);
        this.extensions.put(metaExtensionFQName, metaExtension);
    }

    @Override
    public void addExtension(Collection<WikittyExtension> exts) {
        for (WikittyExtension ext : exts) {
            this.addExtension(ext);
        }
    }

    @Override
    public boolean hasExtension(String extName) {
        return this.extensions.containsKey(extName);
    }

    @Override
    public boolean hasField(String extName, String fieldName) {
        boolean result = false;
        WikittyExtension ext = this.extensions.get(extName);
        if (ext != null) {
            result = ext.getFieldType(fieldName) != null;
        }
        return result;
    }

    @Override
    public boolean hasField(String fqfieldName) {
        boolean result = false;
        try {
            String extName = WikittyExtension.extractExtensionName(fqfieldName);
            String fieldName = WikittyExtension.extractFieldName(fqfieldName);
            result = this.hasField(extName, fieldName);
        }
        catch (Exception eee) {
            log.trace((Object)"Invalide field name is never field", (Throwable)eee);
        }
        return result;
    }

    @Override
    public WikittyExtension getExtension(String ext) {
        WikittyExtension result = this.extensions.get(ext);
        return result;
    }

    @Override
    public Collection<String> getExtensionNames() {
        Set<String> result = this.extensions.keySet();
        return result;
    }

    @Override
    public Collection<String> getExtensionFields(String ext) {
        Collection<String> result = this.getExtension(ext).getFieldNames();
        return result;
    }

    @Override
    public Collection<WikittyExtension> getExtensions() {
        Collection<WikittyExtension> result = this.extensions.values();
        return result;
    }

    @Override
    public Collection<WikittyExtension> getExtensionDependencies(String ext, boolean recursively) {
        HashSet<WikittyExtension> result = new HashSet<WikittyExtension>();
        Collection<WikittyExtension> all = this.extensions.values();
        for (WikittyExtension dependency : all) {
            List<String> requires = dependency.getRequires();
            if (requires == null || requires.isEmpty() || !requires.contains(ext)) continue;
            result.add(dependency);
            if (!recursively) continue;
            String dependencyName = dependency.getName();
            Collection<WikittyExtension> dependencies = this.getExtensionDependencies(dependencyName, recursively);
            result.addAll(dependencies);
        }
        return result;
    }

    @Override
    public FieldType getFieldType(String fqfieldName) {
        String extName = WikittyExtension.extractExtensionName(fqfieldName);
        String fieldName = WikittyExtension.extractFieldName(fqfieldName);
        FieldType result = this.getFieldType(extName, fieldName);
        return result;
    }

    @Override
    public FieldType getFieldType(String extName, String fieldName) {
        FieldType result;
        WikittyExtension ext = this.getExtension(extName);
        if (ext == null) {
            throw new WikittyException(String.format("Extension '%s' doesn't exists on wikitty '%s'", extName, this.id));
        }
        int crochet = fieldName.indexOf("[");
        if (crochet != -1) {
            fieldName = fieldName.substring(0, crochet);
        }
        if ((result = ext.getFieldType(fieldName)) == null) {
            throw new WikittyException(String.format("field '%s' doesn't exists on extension '%s'", fieldName, extName));
        }
        return result;
    }

    @Override
    public void setField(String ext, String fieldName, Object value) {
        if (!this.hasField(ext, fieldName)) {
            String def = "";
            for (WikittyExtension extension : this.extensions.values()) {
                def = def + extension.toDefinition() + "\n";
            }
            throw new WikittyException(String.format("field '%s' is not valid, extensions definition : %s", ext + "." + fieldName, def));
        }
        String key = ext + "." + fieldName;
        Object oldValue = null;
        if (this.getPropertyChangeSupport().hasListeners(key)) {
            oldValue = this.fieldValue.get(key);
        }
        FieldType fieldType = this.getExtension(ext).getFieldType(fieldName);
        Object validValue = fieldType.getValidValue(value);
        this.fieldValue.put(key, validValue);
        if (value != null && fieldType.getType() == WikittyTypes.WIKITTY) {
            if (fieldType.isCollection()) {
                if (value instanceof Collection) {
                    for (Object o : (Collection)value) {
                        Wikitty w = WikittyUtil.getWikitty(o);
                        this.addPreloaded(w);
                    }
                } else {
                    for (Object o : (Object[])value) {
                        Wikitty w = WikittyUtil.getWikitty(o);
                        this.addPreloaded(w);
                    }
                }
            } else {
                Wikitty w = WikittyUtil.getWikitty(value);
                this.addPreloaded(w);
            }
        }
        this.setFieldDirty(ext, fieldName, oldValue, validValue);
    }

    @Override
    public Object getFieldAsObject(String ext, String fieldName) {
        if (!this.hasField(ext, fieldName)) {
            Collection<String> list;
            String type;
            WikittyExtension extension = this.extensions.get(ext);
            if (extension == null) {
                type = "extension";
                list = this.getExtensionNames();
            } else {
                type = "fieldname";
                list = extension.getFieldNames();
            }
            throw new WikittyException(String.format("field '%s' is not a valid field. acceptable %s are: %s", ext + "." + fieldName, type, list));
        }
        String key = ext + "." + fieldName;
        Object result = this.fieldValue.get(key);
        return result;
    }

    @Override
    public byte[] getFieldAsBytes(String ext, String fieldName) {
        Object value = this.getFieldAsObject(ext, fieldName);
        try {
            byte[] result = WikittyUtil.toBinary(value);
            return result;
        }
        catch (WikittyException eee) {
            throw new WikittyException(String.format("field '%s' is not a valid byte[]", ext + "." + fieldName), eee);
        }
    }

    @Override
    public boolean getFieldAsBoolean(String ext, String fieldName) {
        Object value = this.getFieldAsObject(ext, fieldName);
        try {
            boolean result = WikittyUtil.toBoolean(value);
            return result;
        }
        catch (WikittyException eee) {
            throw new WikittyException(String.format("field '%s' is not a valid boolean", ext + "." + fieldName), eee);
        }
    }

    @Override
    public BigDecimal getFieldAsBigDecimal(String ext, String fieldName) {
        Object value = this.getFieldAsObject(ext, fieldName);
        try {
            BigDecimal result = WikittyUtil.toBigDecimal(value);
            return result;
        }
        catch (WikittyException eee) {
            throw new WikittyException(String.format("field '%s' is not a valid numeric", ext + "." + fieldName), eee);
        }
    }

    @Override
    public int getFieldAsInt(String ext, String fieldName) {
        try {
            BigDecimal value = this.getFieldAsBigDecimal(ext, fieldName);
            int result = value.intValue();
            return result;
        }
        catch (WikittyException eee) {
            throw new WikittyException(String.format("field '%s' is not a valid int", ext + "." + fieldName), eee);
        }
    }

    @Override
    public long getFieldAsLong(String ext, String fieldName) {
        try {
            BigDecimal value = this.getFieldAsBigDecimal(ext, fieldName);
            long result = value.longValue();
            return result;
        }
        catch (WikittyException eee) {
            throw new WikittyException(String.format("field '%s' is not a valid int", ext + "." + fieldName), eee);
        }
    }

    @Override
    public float getFieldAsFloat(String ext, String fieldName) {
        try {
            BigDecimal value = this.getFieldAsBigDecimal(ext, fieldName);
            float result = value.floatValue();
            return result;
        }
        catch (WikittyException eee) {
            throw new WikittyException(String.format("field '%s' is not a valid float", ext + "." + fieldName), eee);
        }
    }

    @Override
    public double getFieldAsDouble(String ext, String fieldName) {
        try {
            BigDecimal value = this.getFieldAsBigDecimal(ext, fieldName);
            double result = value.doubleValue();
            return result;
        }
        catch (WikittyException eee) {
            throw new WikittyException(String.format("field '%s' is not a valid float", ext + "." + fieldName), eee);
        }
    }

    @Override
    public String getFieldAsString(String ext, String fieldName) {
        Object value = this.getFieldAsObject(ext, fieldName);
        try {
            String result = WikittyUtil.toString(value);
            return result;
        }
        catch (WikittyException eee) {
            throw new WikittyException(String.format("field '%s' is not a valid String", ext + "." + fieldName), eee);
        }
    }

    @Override
    public Date getFieldAsDate(String ext, String fieldName) {
        Object value = this.getFieldAsObject(ext, fieldName);
        try {
            Date result = WikittyUtil.toDate(value);
            return result;
        }
        catch (WikittyException eee) {
            throw new WikittyException(String.format("field '%s' is not a valid Date", ext + "." + fieldName), eee);
        }
    }

    @Override
    public String getFieldAsWikitty(String ext, String fieldName) {
        Object value = this.getFieldAsObject(ext, fieldName);
        String result = WikittyUtil.toWikitty(value);
        return result;
    }

    @Override
    public Wikitty getFieldAsWikitty(String extName, String fieldName, boolean exceptionIfNotLoaded) {
        String id = this.getFieldAsWikitty(extName, fieldName);
        Wikitty result = null;
        if (id != null) {
            result = this.getPreloaded().get(id);
            if (exceptionIfNotLoaded && result == null) {
                throw new WikittyException(String.format("field %s.%s is not preloaded", extName, fieldName));
            }
        }
        return result;
    }

    @Override
    public <E> List<E> getFieldAsList(String ext, String fieldName, Class<E> clazz) {
        try {
            Collection collection = (Collection)this.getFieldAsObject(ext, fieldName);
            if (collection != null) {
                return new UnModifiableCopyList<E>(clazz, collection);
            }
            return null;
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't get value to field '%s'", ext + "." + fieldName), eee);
        }
    }

    @Override
    public List<Wikitty> getFieldAsWikittyList(String ext, String fieldName, boolean exceptionIfNotLoaded) {
        List<Wikitty> result = null;
        List<String> collection = this.getFieldAsList(ext, fieldName, String.class);
        if (collection != null) {
            result = new ArrayList(collection.size());
            for (String s : collection) {
                Wikitty w = this.getPreloaded().get(s);
                if (exceptionIfNotLoaded && w == null) {
                    throw new WikittyException(String.format("Wikitty for field %s.%s is not preloaded (%s)", ext, fieldName, s));
                }
                result.add(w);
            }
            result = Collections.unmodifiableList(result);
        }
        return result;
    }

    @Override
    public <E> Set<E> getFieldAsSet(String ext, String fieldName, Class<E> clazz) {
        try {
            Collection collection = (Collection)this.getFieldAsObject(ext, fieldName);
            if (collection != null) {
                return new UnModifiableCopySet<E>(clazz, collection);
            }
            return null;
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't get value to field '%s'", ext + "." + fieldName), eee);
        }
    }

    @Override
    public Set<Wikitty> getFieldAsWikittySet(String ext, String fieldName, boolean exceptionIfNotLoaded) {
        Set<Wikitty> result = null;
        Set<String> collection = this.getFieldAsSet(ext, fieldName, String.class);
        if (collection != null) {
            result = new LinkedHashSet();
            for (String s : collection) {
                Wikitty w = this.getPreloaded().get(s);
                if (exceptionIfNotLoaded && w == null) {
                    throw new WikittyException(String.format("Wikitty for field %s.%s is not preloaded (%s)", ext, fieldName, s));
                }
                result.add(w);
            }
            result = Collections.unmodifiableSet(result);
        }
        return result;
    }

    @Override
    public void addToField(String ext, String fieldName, Object value) {
        try {
            FieldType fieldType = this.getExtension(ext).getFieldType(fieldName);
            AbstractCollection col = (LinkedHashSet)this.getFieldAsObject(ext, fieldName);
            if (col == null) {
                col = fieldType.isUnique() ? new LinkedHashSet() : new ArrayList();
                col.add(value);
                this.setField(ext, fieldName, col);
            } else {
                Object validValue = fieldType.getContainedValidObject(value);
                if (!fieldType.isUnique() || !col.contains(validValue)) {
                    if (col.size() + 1 > fieldType.getUpperBound()) {
                        throw new WikittyException(String.format("Can't add value for field '%s', upper bound is reached", ext + "." + fieldName));
                    }
                    col.add(validValue);
                    if (fieldType.getType() == WikittyTypes.WIKITTY) {
                        Wikitty w = WikittyUtil.getWikitty(value);
                        this.addPreloaded(w);
                    }
                    this.setFieldDirty(ext, fieldName, null, col);
                }
            }
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't add value to field '%s'", ext + "." + fieldName), eee);
        }
    }

    @Override
    public void removeFromField(String ext, String fieldName, Object value) {
        try {
            FieldType type;
            Object validValue;
            Collection col = (Collection)this.getFieldAsObject(ext, fieldName);
            if (col != null && col.contains(validValue = (type = this.getExtension(ext).getFieldType(fieldName)).getContainedValidObject(value))) {
                if (col.size() - 1 < type.getLowerBound()) {
                    throw new WikittyException(String.format("Can't remove value for field '%s', lower bound is reached", ext + "." + fieldName));
                }
                if (col.remove(validValue)) {
                    this.setFieldDirty(ext, fieldName, null, col);
                }
            }
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't remove value for field '%s'", ext + "." + fieldName), eee);
        }
    }

    @Override
    public void clearField(String ext, String fieldName) {
        FieldType type = this.getExtension(ext).getFieldType(fieldName);
        if (type.getLowerBound() > 0) {
            throw new WikittyException(String.format("Can't clear values for field '%s', lower bound is > 0", ext + "." + fieldName));
        }
        try {
            Collection col = (Collection)this.getFieldAsObject(ext, fieldName);
            if (col != null) {
                col.clear();
                this.setFieldDirty(ext, fieldName, null, col);
            }
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't clear value for field '%s'", ext + "." + fieldName), eee);
        }
    }

    @Override
    public void addToField(String fqFieldName, Object value) {
        String[] extAndField = fqFieldName.split("\\.");
        this.addToField(extAndField[0], extAndField[1], value);
    }

    @Override
    public void removeFromField(String fqFieldName, Object value) {
        String[] extAndField = fqFieldName.split("\\.");
        this.removeFromField(extAndField[0], extAndField[1], value);
    }

    @Override
    public void clearField(String fqFieldName) {
        String[] extAndField = fqFieldName.split("\\.");
        this.clearField(extAndField[0], extAndField[1]);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Wikitty) {
            Wikitty other = (Wikitty)obj;
            result = this.id.equals(other.getWikittyId());
        }
        return result;
    }

    public int hashCode() {
        if (this.id == null) {
            return super.hashCode();
        }
        return this.id.hashCode();
    }

    @Override
    public Set<String> fieldNames() {
        return this.fieldValue.keySet();
    }

    @Override
    public Map<String, Object> getFieldValue() {
        return Collections.unmodifiableMap(this.fieldValue);
    }

    @Override
    public Set<String> getAllFieldNames() {
        HashSet<String> result = new HashSet<String>();
        for (WikittyExtension ext : this.getExtensions()) {
            String extName = ext.getName() + ".";
            for (String f : ext.getFieldNames()) {
                result.add(extName + f);
            }
        }
        return result;
    }

    @Override
    public Object getFqField(String fqFieldName) {
        Object result = Element.ID.getValue().equalsIgnoreCase(fqFieldName) ? this.getWikittyId() : (Element.ID.getValue().equalsIgnoreCase(fqFieldName) ? this.getExtensionNames() : this.fieldValue.get(fqFieldName));
        return result;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getWikittyVersion() {
        return this.version;
    }

    @Override
    public void setWikittyVersion(String version) {
        this.version = version;
    }

    @Override
    public Set<String> getDirty() {
        return this.fieldDirty;
    }

    @Override
    public void clearDirty() {
        this.fieldDirty.clear();
    }

    @Override
    public void setFqField(String fieldName, Object value) {
        String ext = WikittyExtension.extractExtensionName(fieldName);
        String field = WikittyExtension.extractFieldName(fieldName);
        this.setField(ext, field, value);
    }

    @Override
    public boolean isEmpty() {
        return this.fieldValue.isEmpty();
    }

    public String toString() {
        WikittyExtension extFormat = null;
        WikittyExtension[] exts = this.getExtensions().toArray(new WikittyExtension[this.getExtensions().size()]);
        for (int i = exts.length - 1; i >= 0; --i) {
            WikittyExtension ext = exts[i];
            String format = ext.getTagValue("toString");
            if (!StringUtils.isNotBlank((CharSequence)format)) continue;
            extFormat = ext;
            break;
        }
        String result = extFormat == null ? this.toStringAllField() : extFormat.toString(this);
        return result;
    }

    @Override
    public String toStringAllField() {
        boolean cr = true;
        String str = "[" + this.getWikittyId() + ":" + this.getWikittyVersion() + "] {";
        for (String extName : this.getExtensionNames()) {
            WikittyExtension ext = this.getExtension(extName);
            str = str + (cr ? "\n" : "") + "\t* " + extName + "\n";
            cr = false;
            for (String fieldName : ext.getFieldNames()) {
                str = str + "\t\t* " + fieldName + " = " + this.getFieldAsString(extName, fieldName) + "\n";
            }
        }
        str = str + "}";
        return str;
    }

    @Override
    public String toString(String extName) {
        WikittyExtension ext = this.getExtension(extName);
        String result = ext.toString(this);
        return result;
    }

    @Override
    public WikittyImpl clone() throws CloneNotSupportedException {
        WikittyImpl result = new WikittyImpl(this.id);
        result.replaceWith(this);
        return result;
    }

    static class UnModifiableCopySet<E>
    extends AbstractSet<E> {
        protected Class<E> clazz;
        protected Set<E> contained;

        public UnModifiableCopySet(Class<E> clazz, Collection<E> source) {
            this.clazz = clazz;
            this.contained = new LinkedHashSet<E>(source);
        }

        @Override
        public int size() {
            return this.contained.size();
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                Iterator containedIterator;
                {
                    this.containedIterator = UnModifiableCopySet.this.contained.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.containedIterator.hasNext();
                }

                @Override
                public E next() {
                    Object o = this.containedIterator.next();
                    return WikittyUtil.cast(o, UnModifiableCopySet.this.clazz);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported operation");
                }
            };
        }
    }

    static class UnModifiableCopyList<E>
    extends AbstractList<E> {
        protected Class<E> clazz;
        protected List<E> contained;

        public UnModifiableCopyList(Class<E> clazz, Collection<E> source) {
            this.clazz = clazz;
            this.contained = new ArrayList<E>(source);
        }

        @Override
        public E get(int index) {
            return WikittyUtil.cast(this.contained.get(index), this.clazz);
        }

        @Override
        public int size() {
            return this.contained.size();
        }
    }
}

