/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: ConditionValueString.java 1463 2012-04-05 16:08:38Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.8/wikitty-api/src/main/java/org/nuiton/wikitty/query/conditions/ConditionValueString.java $
 * %%
 * Copyright (C) 2012 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.query.conditions;

import org.apache.commons.lang3.ObjectUtils;

/**
 *
 * @author poussin
 * @version $Revision: 1463 $
 *
 * Last update: $Date: 2012-04-05 18:08:38 +0200 (jeu. 05 avril 2012) $
 * by : $Author: bpoussin $
 */
public class ConditionValueString extends AbstractCondition implements ConditionValue {

    private static final long serialVersionUID = 1L;

    protected String value;

    public ConditionValueString(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    @Override
    public boolean waitCondition() {
        return false;
    }

    @Override
    boolean equalsDeep(Object other) {
        ConditionValueString o = (ConditionValueString)other;
        boolean result = ObjectUtils.equals(this.getValue(), o.getValue());
        return result;
    }

}
