/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.entities;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;

public class WikittyExtension
implements Serializable {
    private static final long serialVersionUID = -3598621577607442972L;
    protected static Pattern NamePattern = Pattern.compile("^\\w+$");
    protected static Pattern fieldNamePattern = Pattern.compile("^\\w+$");
    protected transient PropertyChangeSupport propertyChangeSupport;
    protected String name;
    protected List<String> requires;
    protected String version = "0.0";
    protected Map<String, String> tagValues = new HashMap<String, String>();
    protected LinkedHashMap<String, FieldType> fields = new LinkedHashMap();

    public WikittyExtension() {
    }

    public WikittyExtension(String name) {
        this.setName(name);
    }

    public WikittyExtension(String name, String version, LinkedHashMap<String, FieldType> fields) {
        this(name, version, (Map<String, String>)null, (List<String>)null, fields);
    }

    public WikittyExtension(String name, String version, Map<String, String> tagValues, String requires, LinkedHashMap<String, FieldType> fields) {
        this(name, version, tagValues, StringUtils.split((String)requires, (String)","), fields);
    }

    public WikittyExtension(String name, String version, Map<String, String> tagValues, String[] requires, LinkedHashMap<String, FieldType> fields) {
        this(name, version, tagValues, ArrayUtils.isEmpty((Object[])requires) ? (List<String>)null : Arrays.asList(requires), fields);
    }

    public WikittyExtension(String name, String version, Map<String, String> tagValues, List<String> requires, LinkedHashMap<String, FieldType> fields) {
        if (version == null) {
            throw new IllegalArgumentException("Version must not be null");
        }
        this.setName(name);
        this.version = WikittyUtil.normalizeVersion(version);
        this.setRequires(requires);
        this.setTagValues(tagValues);
        if (fields != null) {
            for (Map.Entry<String, FieldType> entry : fields.entrySet()) {
                String fieldName = entry.getKey();
                FieldType fieldType = entry.getValue();
                this.addField(fieldName, fieldType);
            }
        }
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyName, listener);
    }

    public WikittyExtension cloneForUpgrade() {
        String nextRevision = WikittyUtil.incrementMajorRevision(this.getVersion());
        LinkedHashMap<String, FieldType> nextFields = null;
        if (this.fields != null) {
            nextFields = new LinkedHashMap<String, FieldType>();
            for (Map.Entry<String, FieldType> entry : this.fields.entrySet()) {
                FieldType type = entry.getValue();
                FieldType nextType = new FieldType(type.getType(), type.getLowerBound(), type.getUpperBound());
                Set<String> tagNames = type.getTagNames();
                if (tagNames != null) {
                    for (String tagName : tagNames) {
                        String tagValue = type.getTagValue(tagName);
                        nextType.addTagValue(tagName, tagValue);
                    }
                }
                nextFields.put(entry.getKey(), nextType);
            }
        }
        WikittyExtension result = new WikittyExtension(this.name, nextRevision, this.tagValues, this.requires, nextFields);
        return result;
    }

    public static String computeId(String name, String version) {
        String result = name + "[" + version + "]";
        return result;
    }

    public static String computeName(String id) {
        int i = id.lastIndexOf("[");
        String result = id;
        if (i != -1) {
            result = id.substring(0, i);
        }
        return result;
    }

    public static String computeVersion(String id) {
        int b = id.lastIndexOf("[");
        int e = id.lastIndexOf("]");
        String result = null;
        if (b != -1 && e != -1) {
            result = id.substring(b + 1, e);
        }
        result = WikittyUtil.normalizeVersion(result);
        return result;
    }

    public static boolean isFqField(String fieldName) {
        int i = fieldName.indexOf(".");
        boolean result = i > 0;
        return result;
    }

    public static String extractExtensionName(String fqFieldName) {
        int i = fqFieldName.indexOf(".");
        if (i > 0) {
            String result = fqFieldName.substring(0, i);
            return result;
        }
        throw new IllegalArgumentException(String.format("Your argument '%s' is not fully qualified field name", fqFieldName));
    }

    public static String extractFieldName(String fqFieldName) {
        int i = fqFieldName.indexOf(".");
        if (i > 0) {
            String result = fqFieldName.substring(i + 1);
            int b = result.lastIndexOf("[");
            if (b > 0) {
                result = result.substring(0, b);
            }
            return result;
        }
        throw new IllegalArgumentException(String.format("Your argument '%s' is not fully qualified field name", fqFieldName));
    }

    public String getId() {
        String result = WikittyExtension.computeId(this.getName(), this.getVersion());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        if (!NamePattern.matcher(name).matches()) {
            throw new IllegalArgumentException("Name contains non alphanumeric characters");
        }
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public List<String> getRequires() {
        return this.requires;
    }

    public void setRequires(List<String> requires) {
        if (requires == null) {
            requires = Collections.EMPTY_LIST;
        }
        this.requires = Collections.unmodifiableList(new ArrayList(requires));
        this.getPropertyChangeSupport().firePropertyChange("requires", null, this.requires);
    }

    public FieldType getFieldType(String fieldName) {
        return this.fields.get(fieldName);
    }

    public Collection<String> getFieldNames() {
        Set<String> result = this.fields.keySet();
        return result;
    }

    public void addField(String fieldName, FieldType type) {
        Matcher matcher = fieldNamePattern.matcher(fieldName);
        if (!matcher.find()) {
            throw new IllegalArgumentException("For field name [" + fieldName + "], only word character [a-zA-Z_0-9] is accepted");
        }
        this.fields.put(fieldName, type);
        this.getPropertyChangeSupport().firePropertyChange("fields", null, this.fields);
    }

    public void removeField(String fieldName) {
        this.fields.remove(fieldName);
        this.getPropertyChangeSupport().firePropertyChange("fields", null, this.fields);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public void addTagValue(String tag, String value) {
        this.tagValues.put(tag, value);
        this.getPropertyChangeSupport().firePropertyChange("tagValues", null, this.tagValues);
    }

    public String getTagValue(String tag) {
        String result = this.tagValues.get(tag);
        return result;
    }

    public Set<String> getTagNames() {
        return this.tagValues.keySet();
    }

    public Map<String, String> getTagValues() {
        return this.tagValues;
    }

    public void setTagValues(Map<String, String> tagValues) {
        if (tagValues == null) {
            tagValues = new HashMap<String, String>();
        }
        Map<String, String> oldValue = this.tagValues;
        this.tagValues = tagValues;
        this.getPropertyChangeSupport().firePropertyChange("tagValues", oldValue, tagValues);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof WikittyExtension) {
            WikittyExtension other = (WikittyExtension)obj;
            result = this.getId().equals(other.getId());
        }
        return result;
    }

    public String toString() {
        return this.getId();
    }

    public String toDefinition() {
        String result = "Extension " + this.getId();
        result = result + WikittyUtil.tagValuesToString(this.tagValues);
        result = result + " {\n";
        for (String fieldName : this.fields.keySet()) {
            result = result + this.fields.get(fieldName).toDefinition(fieldName) + "\n";
        }
        result = result + "}";
        return result;
    }

    public String toString(Wikitty wikitty) {
        String format = this.getTagValue("toString");
        String result = StringUtils.isNotBlank((String)format) ? WikittyUtil.format(format, wikitty) : wikitty.toStringAllField();
        return result;
    }
}

