package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;

public abstract class WikittyGroupAbstract extends BusinessEntityImpl implements WikittyGroup {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionWikittyGroup;

    @Override
    public String getName() {
String value = WikittyGroupHelper.getName(getWikitty());
return value;
}

    @Override
    public void setName(String name) {
String oldValue = getName();
WikittyGroupHelper.setName(getWikitty(), name);
getPropertyChangeSupport().firePropertyChange(WikittyGroup.FIELD_WIKITTYGROUP_NAME, oldValue, getName());
}

    @Override
    public Set<String> getMembers() {
Set<String> result = WikittyGroupHelper.getMembers(getWikitty());
return result;
}

    @Override
    public void setMembers(Set<String> members) {
Set<String> oldValue = getMembers();
WikittyGroupHelper.setMembers(getWikitty(), members);
getPropertyChangeSupport().firePropertyChange(WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, oldValue, getMembers());
}

    @Override
    public void addAllMembers(Collection<String> members) {
Set<String> oldValue = getMembers();
WikittyGroupHelper.addAllMembers(getWikitty(), members);
getPropertyChangeSupport().firePropertyChange(WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, oldValue, getMembers());
}

    @Override
    public void addMembers(String... element) {
Set<String> oldValue = getMembers();
WikittyGroupHelper.addMembers(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, oldValue, getMembers());
}

    @Override
    public void removeMembers(String... element) {
Set<String> oldValue = getMembers();
WikittyGroupHelper.removeMembers(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, oldValue, getMembers());
}

    @Override
    public void clearMembers() {
WikittyGroupHelper.clearMembers(getWikitty());
getPropertyChangeSupport().firePropertyChange(WikittyGroup.FIELD_WIKITTYGROUP_MEMBERS, null, getMembers());
}

    public WikittyGroupAbstract() {
        super();
}

    public WikittyGroupAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public WikittyGroupAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionWikittyGroup = new WikittyExtension(EXT_WIKITTYGROUP,
                "1.0", // version
                WikittyUtil.tagValuesToMap(" version=\"1.0\""), // tag/values
                (List)null,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "String name unique=\"true\"", 
                                             "Wikitty members[0-*] unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionWikittyGroup);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return WikittyGroupHelper.toString(getWikitty());
}

} //WikittyGroupAbstract
