/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.services.WikittyExtensionMigration;

public class WikittyExtensionMigrationRegistry {
    private static Log log = LogFactory.getLog(WikittyExtensionMigrationRegistry.class);
    protected ApplicationConfig config;

    public WikittyExtensionMigrationRegistry(ApplicationConfig config) {
        this.config = config;
    }

    public WikittyExtensionMigration get(String extensionName) {
        try {
            String key = WikittyConfigOption.WIKITTY_MIGRATION_CLASS.getKey() + extensionName;
            WikittyExtensionMigration result = (WikittyExtensionMigration)this.config.getOptionAsSingleton(WikittyExtensionMigration.class, key);
            return result;
        }
        catch (Exception eee) {
            throw new WikittyException("Can't get migration class in configuration", eee);
        }
    }

    public void put(String extensionName, WikittyExtensionMigration o) {
        String key = WikittyConfigOption.WIKITTY_MIGRATION_CLASS.getKey() + extensionName;
        this.config.putObject(key, (Object)o);
    }
}

