/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: SearchTest.java 805 2011-04-13 16:59:23Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.1.2/wikitty-api/src/test/java/org/nuiton/wikitty/conform/SearchTest.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.conform;

import static junit.framework.Assert.assertEquals;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Before;

import org.junit.Test;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.entities.ExtensionFactory;
import org.nuiton.wikitty.entities.FieldType.TYPE;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.search.Search;

public class SearchTest extends AbstractTestConformance {
    
    private final static Log log = LogFactory.getLog(AbstractTestConformance.class);

    private ApplicationConfig config = null;

    @Override
    public ApplicationConfig getConfig() {
        if (config == null) {
            config = WikittyConfig.getConfig(); // default config for in memory
//            String msg = "Try to passe test with " + config.getPrintableConfig("wikitty.*", 50);
//            log.info(msg);
        }
        return config;
    }

    @Before
    public void clearStorage() throws Exception {
        getProxy().clear();
    }

    /*
     * TODO Will contains all conformance tests to the search features.
     */

    public void testSearch() throws Exception {
        String value = "";
        Criteria criteria = 
            Search.query()
                .eq( "element", value )
                .gt( "element2", value )
                .or()
                .lt( "element3", value )
                .criteria();
        /*
         * is equivalent to :
         *  ( element = value ) AND ( ( element2 > value ) OR ( element3 < value ) ) 
         */
    }
    
    @Test
    public void testSearch2() throws Exception {
        WikittyExtension ext = ExtensionFactory.create("testExt", "1")
            .addField("name", TYPE.STRING)
            .addField("age", TYPE.NUMERIC)
            .addField("birth", TYPE.DATE)
            .extension();
        List<Wikitty> wikitties = new LinkedList<Wikitty>();
        
        Wikitty w = new WikittyImpl();
        w.addExtension(ext);
        w.setField(ext.getName(), "name", "Guillaume");
        w.setField(ext.getName(), "age", "27");
        w.setField(ext.getName(), "birth", "19/04/1968");
        wikitties.add( w );
        
        w = new WikittyImpl();
        w.addExtension(ext);
        w.setField(ext.getName(), "name", "Toto");
        w.setField(ext.getName(), "age", "125");
        w.setField(ext.getName(), "birth", "19/04/1968 15:12");
        wikitties.add( w );
        
        wikitties = getProxy().storeWikitty(wikitties);

        // Testing search on a date criteria
        Criteria criteria = Search.query()
                    .gt("testExt.birth", "19/04/1968 15:00")
                    .criteria();
        PagedResult<String> result = getProxy().findAllIdByCriteria(criteria);
        List<String> found = result.getAll();
        assertEquals(1, found.size());
        Wikitty wikittyFound = getProxy().restore(found.get(0));
        log.info( wikittyFound.getFieldAsString(ext.getName(), "birth") );

        // Testing search on a date criteria
        criteria = Search.query()
                         .ge("testExt.birth", "19/04/1968")
                         .criteria();
        result = getProxy().findAllIdByCriteria(criteria);
        found = result.getAll();
        assertEquals(2, found.size());
        wikittyFound = getProxy().restore(found.get(0));
        log.info( wikittyFound.getFieldAsString(ext.getName(), "birth") );
              
        criteria = Search.query()
            .eq("testExt.name", "Guillaume")
            .criteria();
        result = getProxy().findAllIdByCriteria(criteria);
        found = result.getAll();
        assertEquals(1, found.size());
        wikittyFound = getProxy().restore(found.get(0));
        log.info( wikittyFound.getFieldAsString(ext.getName(), "name") );
        
        criteria = Search.query()
            .eq("testExt.age", "125")
            .criteria();
        result = getProxy().findAllIdByCriteria(criteria);
        found = result.getAll();
        assertEquals(1, found.size());
        wikittyFound = getProxy().restore(found.get(0));
        log.info( wikittyFound.getFieldAsString(ext.getName(), "name") );
        
        criteria = Search.query()
            .gt("testExt.age", "10")
            .criteria();
        result = getProxy().findAllIdByCriteria(criteria);
        found = result.getAll();
        assertEquals(2, found.size());
        wikittyFound = getProxy().restore(found.get(0));
        log.info( wikittyFound.getFieldAsString(ext.getName(), "name") );
        wikittyFound = getProxy().restore(found.get(1));
        log.info( wikittyFound.getFieldAsString(ext.getName(), "name") );
        
        Wikitty exemple = new WikittyImpl();
        exemple.addExtension(ext);
        exemple.setField(ext.getName(), "name", "Guillaume");
        exemple.setField(ext.getName(), "age", "27");
        result = getProxy().findAllIdByCriteria(Search.query(exemple).criteria() );
        found = result.getAll();
        assertEquals(1, found.size());
        wikittyFound = getProxy().restore(found.get(0));
        log.info( wikittyFound.getFieldAsString(ext.getName(), "name") );
        
        exemple = new WikittyImpl();
        exemple.addExtension(ext);
        exemple.setField(ext.getName(), "name", "Guillaume");
        exemple.setField(ext.getName(), "age", "125");
        result = getProxy().findAllIdByCriteria(Search.query(exemple).criteria() );
        found = result.getAll();
        assertEquals(0, found.size());
        // log.info( found.get(0).getFieldAsString(ext.getName(), "name") );
        
    }
    
}
