/*
 * #%L
 * Wikitty :: api
 * *
 * $Id: WikittyTree.java 461 2010-10-29 15:19:55Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.0.3/wikitty-api/src/main/java/org/nuiton/wikitty/WikittyTree.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.wikitty.entities.WikittyTreeNode;

public class WikittyTree implements Serializable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 5785244346524975096L;

    protected WikittyTreeNode node;
    protected List<WikittyTree> children;
    
    public void setNode(WikittyTreeNode node) {
        this.node = node;
    }

    public WikittyTreeNode getNode() {
        return node;
    }
    
    public void addChild(WikittyTree tree) {
        getChildren().add( tree );
    }
    
    public List<WikittyTree> getChildren() {
        if ( children == null ) {
            children = new ArrayList<WikittyTree>();
        }
        return children;
    }
    
    public String getName() {
        return node.getName();
    }
}
