/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: AssociatedRestriction.java 417 2010-10-15 15:24:44Z sletellier $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-2.2.2/wikitty-api/src/main/java/org/nuiton/wikitty/search/AssociatedRestriction.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.search;

public class AssociatedRestriction extends Restriction {

    private static final long serialVersionUID = 1L;

    private Restriction associatedRestriction;
    private Restriction embededRestriction;
    private Element element;
    
    public AssociatedRestriction(Restriction parentRestriction, Restriction embededRestriction, Element element) {
        this.associatedRestriction = parentRestriction;
        this.embededRestriction = embededRestriction;
        this.name = RestrictionName.ASSOCIATED;
        this.element = element;
    }
    
    public Restriction getParentRestrictionDto() {
        return associatedRestriction;
    }
    
    public Element getElement() {
        return element;
    }
    
    public void setElement(Element element) {
        this.element = element;
    }

    public Restriction getRestriction() {
        return embededRestriction;
    }
}
