/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: WikittyTransaction.java 417 2010-10-15 15:24:44Z sletellier $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-2.2.2/wikitty-api/src/main/java/org/nuiton/wikitty/WikittyTransaction.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.Status;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/***
 * Manage JTA transaction. You can store some information during execution.
 */
public class WikittyTransaction {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(WikittyTransaction.class);

    /** permet d'attacher n'importe quoi a une transaction */
    protected Map<Object, Object> tagValues;

    /** cache static utilise par le WikittyServiceCached */
    transient protected WikittyCache cache = null;

    public WikittyTransaction() {
        tagValues = new HashMap<Object, Object>();
    }

    /**
     * Visibilite 'default' car est uilise par WikittyServiceCached qui est dans
     * le meme package et a priori seulement lui en a besoin
     * 
     * @return
     */
    WikittyCache getCache() {
       if (cache == null) {
           cache = new WikittyCache();
        }
        return cache;
    }

    public Object getTagValue(Object tag) {
        return tagValues.get(tag);
    }

    public void setTagValue(Object tag, Object value) {
        tagValues.put(tag, value);
    }

    public UserTransaction getUserTransaction() {
        return com.arjuna.ats.jta.UserTransaction.userTransaction();
    }

    public TransactionManager getTransactionManager() {
        return com.arjuna.ats.jta.TransactionManager.transactionManager();
    }

    public void begin() {
        UserTransaction userTransaction = getUserTransaction();
        try {
            if (log.isDebugEnabled()) {
                log.debug("Begin transaction");
            }
            userTransaction.setTransactionTimeout(3600); // FIXME: jru 20100115 error in service if call during lot of times
            userTransaction.begin();
        } catch (Exception eee) {
            throw new WikittyException("Error on begin JTA transaction", eee);
        }
    }

    public void commit() {
        UserTransaction userTransaction = getUserTransaction();
        try {
            if (log.isDebugEnabled()) {
                log.debug("Commit transaction");
            }
            userTransaction.commit();
        } catch (Exception eee) {
            throw new WikittyException("Error on commit JTA transaction", eee);
        }
    }

    public void rollback() {
        UserTransaction userTransaction = getUserTransaction();
        try {
            if(userTransaction.getStatus() != Status.STATUS_NO_TRANSACTION
                    && userTransaction.getStatus() != Status.STATUS_UNKNOWN) {
                if (log.isDebugEnabled()) {
                    log.debug("Rollback transaction");
                }
                userTransaction.rollback();
            }
        } catch (Exception eee) {
            throw new WikittyException("Error on roolback JTA transaction", eee);
        }
    }
}
