/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: WikittyStorage.java 417 2010-10-15 15:24:44Z sletellier $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-2.2.2/wikitty-api/src/main/java/org/nuiton/wikitty/WikittyStorage.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.wikitty;

import java.util.Collection;

/**
 * WikittyStorage is used to abstract data and extension storage in WikittyService.
 *
 * @author poussin
 * @version $Revision: 417 $
 *
 * Last update: $Date: 2010-10-15 17:24:44 +0200 (ven., 15 oct. 2010) $
 * by : $Author: sletellier $
 */
public interface WikittyStorage {

    /**
     * Store wikitty in storage.
     * 
     * @param transaction transaction
     * @param wikitties wikitty collection
     * @param force boolean force non version version increment on saved wikitty
     *              or force version on wikitty creation (version 0.0)
     * 
     * @return information usefull for client side update data
     */
    public UpdateResponse store(WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean force);

    /**
     * Return true if id exists in storage.
     * 
     * @param transaction transaction
     * @param id id to check
     * @return {@code true} if wikitty id exists
     */
    public boolean exists(WikittyTransaction transaction, String id);

    /**
     * Return true if wikitty object with this id are marked deleted.
     * 
     * @param transaction transaction
     * @param id id to check
     * @return {@code true} if wikitty id is deleted
     */
    public boolean isDeleted(WikittyTransaction transaction, String id);

    /**
     * Restore list of wikitty object.
     * 
     * @param transaction transaction
     * @param id list of wikitty id
     * @param fqFieldName list of field that must be loaded, other fields
     *      can be not loaded
     * @return found wikitty
     * @throws WikittyException if wikitty not found
     */
    public Wikitty restore(WikittyTransaction transaction, String id,
            String ... fqFieldName) throws WikittyException;

    /**
     * Delete all object with id argument.
     * 
     * @param transaction transaction
     * @param idList
     * @return delete response
     * @throws WikittyException If id is not valid or don't exist.
     */
    public UpdateResponse delete(WikittyTransaction transaction, Collection<String> idList) throws WikittyException;

    /**
     * Scan all wikitties with specific scanner, even if the wikitty is deleted.
     * 
     * @param transaction transaction
     * @param scanner scanner
     */
    void scanWikitties(WikittyTransaction transaction, Scanner scanner);

    /**
     * Call each time wikitty is scan.
     */
    public static interface Scanner {
        void scan(String wikittyId);
    }

    /**
     * Remove all wikitty.
     * 
     * @param transaction transaction
     */
    public void clear(WikittyTransaction transaction);

}
