/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.api;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.nuiton.wikitty.ExtensionFactory;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyImpl;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.api.AbstractTestApi;
import org.nuiton.wikitty.conform.StorageTest;

public class CommonTest
extends AbstractTestApi {
    private static Log log = LogFactory.getLog(CommonTest.class);
    private static String UNKNOWN = "unknown";

    @Test
    public void testWikittyId() throws Exception {
        WikittyImpl w = new WikittyImpl();
        Assert.assertNotNull((String)"Wikitty should got an ID", (Object)w.getId());
        WikittyImpl w2 = new WikittyImpl(w.getId());
        Assert.assertEquals((String)"Wikitty with same ID must be equals", (Object)w, (Object)w2);
    }

    @Test
    public void testWikittyExtension() throws Exception {
        WikittyImpl wikitty = new WikittyImpl();
        WikittyExtension ext = new WikittyExtension("invalidExt", "1", null, null);
        wikitty.addExtension(ext);
        Assert.assertTrue((boolean)wikitty.hasExtension("invalidExt"));
        ext = new WikittyExtension("invalideExt2", "1", null, new LinkedHashMap());
        wikitty.addExtension(ext);
        Assert.assertFalse((boolean)wikitty.hasExtension("invalidExt2"));
        ext = new WikittyExtension("master", "1", null, null);
        wikitty.addExtension(ext);
        Assert.assertTrue((boolean)wikitty.hasExtension("master"));
        ext = new WikittyExtension("slave", "1", "master", null);
        wikitty.addExtension(ext);
        Assert.assertTrue((boolean)wikitty.hasExtension("slave"));
        ext = new WikittyExtension("badslave", "1", "nomaster", null);
        try {
            wikitty.addExtension(ext);
            Assert.assertFalse((boolean)true);
        }
        catch (Exception eee) {
            Assert.assertTrue((boolean)true);
        }
        Assert.assertFalse((boolean)wikitty.hasExtension("badslave"));
        String testExtName = "testExt";
        ext = ExtensionFactory.create((String)testExtName, (String)"1").addField("fieldName0", FieldType.TYPE.NUMERIC).addField("fieldName1", FieldType.TYPE.STRING).addField("fieldName2", FieldType.TYPE.NUMERIC).extension();
        WikittyImpl w = new WikittyImpl();
        Assert.assertFalse((boolean)w.hasExtension(testExtName));
        w.addExtension(ext);
        Assert.assertTrue((boolean)w.hasExtension(testExtName));
        for (int i = 0; i < 3; ++i) {
            String fieldName = "fieldName" + i;
            Assert.assertTrue((String)("Field " + fieldName + " not found"), (boolean)w.hasField(testExtName, fieldName));
        }
        WikittyExtension ext2 = ExtensionFactory.create((String)"otherExt", (String)"1").addField("fieldName0", FieldType.TYPE.NUMERIC).addField("fieldName1", FieldType.TYPE.STRING).addField("fieldName2", FieldType.TYPE.NUMERIC).addField("fieldName3", FieldType.TYPE.NUMERIC).addField("fieldName4", FieldType.TYPE.NUMERIC).extension();
        w.addExtension(ext2);
        for (int i = 0; i < 5; ++i) {
            String fieldName = "fieldName" + i;
            if (i < 3) {
                Assert.assertTrue((String)("Field " + fieldName + " not found"), (boolean)w.hasField(testExtName, fieldName));
            }
            Assert.assertTrue((String)("Field " + fieldName + " not found"), (boolean)w.hasField("otherExt", fieldName));
        }
    }

    @Test
    public void testWikittyExtensionCorrectFieldName() throws Exception {
        ExtensionFactory.create((String)"correctExtension", (String)"1").addField("correctFieldName", FieldType.TYPE.NUMERIC).extension();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWikittyExtensionIncorrectFieldName() throws Exception {
        ExtensionFactory.create((String)"incorrectExtension", (String)"1").addField("incorrectFieldName#", FieldType.TYPE.NUMERIC).extension();
    }

    @Test
    public void testFieldAssigment() throws Exception {
        Wikitty w = this.createBasicWikitty();
        try {
            w.setField(UNKNOWN, "fieldName", (Object)"fieldValue");
            Assert.fail((String)"Should throw a runtime exception !");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            w.setField("wikittyExt", "non-existing-fieldName", (Object)"fieldValue");
            Assert.fail((String)"Should throw a runtime exception !");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        w.addExtension(StorageTest.EXT_TEST);
        String stringValue = "A Test Value";
        w.setField("wikittyExt", "fieldName0", (Object)stringValue);
        Assert.assertEquals((String)stringValue, (String)w.getFieldAsString("wikittyExt", "fieldName0"));
        int intValue = 123456;
        w.setField("wikittyExt", "fieldName1", (Object)intValue);
        Assert.assertEquals((int)intValue, (int)w.getFieldAsInt("wikittyExt", "fieldName1"));
        Date dateValue = new Date();
        w.setField("wikittyExt", "fieldName2", (Object)new Date());
        Assert.assertEquals((Object)dateValue, (Object)w.getFieldAsDate("wikittyExt", "fieldName2"));
        for (int i = 0; i < 3; ++i) {
            w.setField("wikittyExt", "fieldName" + i, null);
        }
    }

    private Wikitty createBasicWikitty() {
        WikittyExtension ext = ExtensionFactory.create((String)"wikittyExt", (String)"1").addField("name", FieldType.TYPE.STRING).extension();
        WikittyImpl w = new WikittyImpl();
        w.addExtension(ext);
        w.setField("wikittyExt", "name", (Object)"foobar");
        return w;
    }

    @Test
    public void testFieldCastRules() throws Exception {
        Wikitty w = this.createBasicWikitty();
        w.addExtension(StorageTest.EXT_TEST);
        String stringValue = "Hello";
        w.setField("wikittyExt", "fieldName0", new Object(){

            public String toString() {
                return "Hello";
            }
        });
        w.setField("wikittyExt", "fieldName1", (Object)new Integer(123));
        Assert.assertEquals((int)123, (int)w.getFieldAsInt("wikittyExt", "fieldName1"));
        w.setField("wikittyExt", "fieldName1", (Object)"123");
        Assert.assertEquals((int)123, (int)w.getFieldAsInt("wikittyExt", "fieldName1"));
        Calendar cal = Calendar.getInstance(Locale.ROOT);
        cal.set(1982, 0, 23, 0, 0, 0);
        cal.set(14, 0);
        w.setField("wikittyExt", "fieldName2", (Object)WikittyUtil.formatDate((Date)cal.getTime()));
        Assert.assertEquals((Object)cal.getTime(), (Object)w.getFieldAsDate("wikittyExt", "fieldName2"));
    }

    @Test
    public void testFieldBoundsManagement() throws Exception {
        String fieldName = "fieldName0";
        WikittyExtension ext = ExtensionFactory.create((String)"wikittyExt", (String)"1").addField(fieldName, FieldType.TYPE.NUMERIC).maxOccur(Integer.MAX_VALUE).extension();
        WikittyImpl w = new WikittyImpl();
        w.addExtension(ext);
        try {
            w.setField("wikittyExt", fieldName, (Object)123);
            Assert.fail((String)"setting an int to a list of int is forbidden !");
        }
        catch (WikittyException e) {
            // empty catch block
        }
        for (int i = 0; i < 10; ++i) {
            w.addToField("wikittyExt", fieldName, (Object)i);
        }
        int z = 0;
        Iterator i$ = w.getFieldAsList("wikittyExt", fieldName, Integer.class).iterator();
        while (i$.hasNext()) {
            int value = (Integer)i$.next();
            Assert.assertEquals((String)("element " + z + " failed"), (int)z, (int)value);
            ++z;
        }
        Integer[] listInt = new Integer[]{4, 2, 8, 9, 5, -12, Integer.MIN_VALUE, Integer.MAX_VALUE};
        w.setField("wikittyExt", fieldName, Arrays.asList(listInt));
        z = 0;
        Iterator i$2 = w.getFieldAsList("wikittyExt", fieldName, Integer.class).iterator();
        while (i$2.hasNext()) {
            int value = (Integer)i$2.next();
            Assert.assertEquals((int)listInt[z++], (int)value);
        }
        w.removeFromField("wikittyExt", fieldName, (Object)Integer.MIN_VALUE);
        List values = w.getFieldAsList("wikittyExt", fieldName, Integer.class);
        z = 0;
        Iterator i$3 = w.getFieldAsList("wikittyExt", fieldName, Integer.class).iterator();
        while (i$3.hasNext()) {
            int value = (Integer)i$3.next();
            Assert.assertEquals((int)(z == values.size() - 1 ? Integer.MAX_VALUE : listInt[z++]), (int)value);
        }
        w.clearField("wikittyExt", fieldName);
        values = w.getFieldAsList("wikittyExt", fieldName, Integer.class);
        Assert.assertTrue((boolean)values.isEmpty());
    }

    @Test
    public void testPerfFieldAccess() throws Exception {
        int MAX = 100000;
        HashMap<String, Object> m = new HashMap<String, Object>();
        Wikitty w = this.createBasicWikitty();
        w.addExtension(StorageTest.EXT_TEST);
        PerfFieldAccesClass z = new PerfFieldAccesClass();
        long time = System.currentTimeMillis();
        for (int i = 0; i < MAX; ++i) {
            String stringValue = "A Test Value";
            m.put("wikittyExt.fieldName0", stringValue);
            int intValue = 123456;
            m.put("wikittyExt.fieldName1", intValue);
            Date dateValue = new Date();
            m.put("wikittyExt.fieldName2", dateValue);
        }
        long timeSetM = System.currentTimeMillis() - time;
        time = System.currentTimeMillis();
        String tmp = "";
        for (int i = 0; i < MAX; ++i) {
            String stringValue = (String)m.get("wikittyExt.fieldName0");
            int intValue = (Integer)m.get("wikittyExt.fieldName1");
            Date dateValue = (Date)m.get("wikittyExt.fieldName2");
            tmp = stringValue + intValue + dateValue;
        }
        long timeGetM = System.currentTimeMillis() - time;
        time = System.currentTimeMillis();
        for (int i = 0; i < MAX; ++i) {
            String stringValue = "A Test Value";
            w.setField("wikittyExt", "fieldName0", (Object)stringValue);
            int intValue = 123456;
            w.setField("wikittyExt", "fieldName1", (Object)intValue);
            Date dateValue = new Date();
            w.setField("wikittyExt", "fieldName2", (Object)new Date());
        }
        long timeSetW = System.currentTimeMillis() - time;
        time = System.currentTimeMillis();
        for (int i = 0; i < MAX; ++i) {
            String stringValue = w.getFieldAsString("wikittyExt", "fieldName0");
            int intValue = w.getFieldAsInt("wikittyExt", "fieldName1");
            Date dateValue = w.getFieldAsDate("wikittyExt", "fieldName2");
            tmp = stringValue + intValue + dateValue;
        }
        long timeGetW = System.currentTimeMillis() - time;
        time = System.currentTimeMillis();
        for (int i = 0; i < MAX; ++i) {
            String stringValue = "A Test Value";
            z.setStringValue(stringValue);
            int intValue = 123456;
            z.setIntValue(intValue);
            Date dateValue = new Date();
            z.setDateValue(dateValue);
        }
        long timeSetZ = System.currentTimeMillis() - time;
        time = System.currentTimeMillis();
        for (int i = 0; i < MAX; ++i) {
            String stringValue = z.getStringValue();
            int intValue = z.getIntValue();
            Date dateValue = z.getDateValue();
            tmp = stringValue + intValue + dateValue;
        }
        long timeGetZ = System.currentTimeMillis() - time;
        log.info((Object)("Time m set: " + timeSetM + " Time m get: " + timeGetM));
        log.info((Object)("Time w set: " + timeSetW + " Time w get: " + timeGetW));
        log.info((Object)("Time z set: " + timeSetZ + " Time z get: " + timeGetZ));
    }

    public static void main(String[] args) throws Exception {
        new CommonTest().testPerfFieldAccess();
    }

    public static class PerfFieldAccesClass {
        String stringValue;
        int intValue;
        Date dateValue;

        public String getStringValue() {
            return this.stringValue;
        }

        public void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public void setIntValue(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public void setDateValue(Date dateValue) {
            this.dateValue = dateValue;
        }

        public Date getDateValue() {
            return this.dateValue;
        }
    }
}

