/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.struts2;

import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.ResourceBundleTextProvider;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.web.struts2.BaseAction;

public class I18nTextProvider
implements ResourceBundleTextProvider {
    private static final Log log = LogFactory.getLog(BaseAction.class);
    public static final String UNTRANSLATED_MARKER = "???";
    protected LocaleProvider localeProvider;

    protected String getSafeText(String key, String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Key [" + key + "] is not translated"));
            }
            return UNTRANSLATED_MARKER + key + UNTRANSLATED_MARKER;
        }
        return value;
    }

    public void setBundle(ResourceBundle bundle) {
    }

    public void setClazz(Class clazz) {
    }

    public void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    public boolean hasKey(String key) {
        Locale locale = this.localeProvider.getLocale();
        boolean result = I18n.hasKey((Locale)locale, (String)key);
        return result;
    }

    protected String getTextFromLocale(String key, String defaultValue) {
        Locale locale = this.localeProvider.getLocale();
        String result = I18n.l((Locale)locale, (String)key, (Object[])new Object[0]);
        if (result == null) {
            result = defaultValue;
        }
        result = this.getSafeText(key, result);
        return result;
    }

    protected String getTextFromLocale(String key, String defaultValue, Object ... args) {
        Locale locale = this.localeProvider.getLocale();
        String result = I18n.l((Locale)locale, (String)key, (Object[])args);
        if (result == null) {
            result = defaultValue;
        }
        result = this.getSafeText(key, result);
        return result;
    }

    public String getText(String aTextName) {
        String value = this.getTextFromLocale(aTextName, null);
        return value;
    }

    public String getText(String aTextName, String defaultValue) {
        String value = this.getTextFromLocale(aTextName, defaultValue);
        return value;
    }

    public String getText(String aTextName, String defaultValue, String obj) {
        String value = this.getTextFromLocale(aTextName, defaultValue, obj);
        return value;
    }

    public String getText(String aTextName, List<?> args) {
        Object[] array = args.toArray();
        String value = this.getTextFromLocale(aTextName, null, array);
        return value;
    }

    public String getText(String key, String[] args) {
        String value = this.getTextFromLocale(key, null, args);
        return value;
    }

    public String getText(String aTextName, String defaultValue, List<?> args) {
        Object[] array = args.toArray();
        String value = this.getTextFromLocale(aTextName, defaultValue, array);
        return value;
    }

    public String getText(String key, String defaultValue, String[] args) {
        String value = this.getTextFromLocale(key, defaultValue, args);
        return value;
    }

    public String getText(String key, String defaultValue, List<?> args, ValueStack stack) {
        String value = this.getText(key, defaultValue, args);
        return value;
    }

    public String getText(String key, String defaultValue, String[] args, ValueStack stack) {
        String value = this.getText(key, defaultValue, args);
        return value;
    }

    public ResourceBundle getTexts(String bundleName) {
        return null;
    }

    public ResourceBundle getTexts() {
        return null;
    }
}

