/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.templates;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.eugene.AbstractMetaTransformer;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.java.BeanTransformer;
import org.nuiton.eugene.java.JavaEnumerationTransformer;
import org.nuiton.eugene.java.JavaInterfaceTransformer;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.validator.AttributeNamesValidator;
import org.nuiton.eugene.models.object.validator.ClassNamesValidator;
import org.nuiton.eugene.models.object.validator.ObjectModelValidator;
import org.nuiton.topia.templates.ApplicationContextTransformer;
import org.nuiton.topia.templates.EntityDaoTransformer;
import org.nuiton.topia.templates.EntityEnumTransformer;
import org.nuiton.topia.templates.EntityHibernateMappingGenerator;
import org.nuiton.topia.templates.EntityTransformer;
import org.nuiton.topia.templates.PersistenceContextTransformer;
import org.nuiton.topia.templates.TopiaJavaValidator;
import org.nuiton.topia.templates.TopiaRelationValidator;
import org.nuiton.topia.templates.TopiaTemplateHelper;

@Component(role=Template.class, hint="org.nuiton.topia.templates.TopiaMetaTransformer")
public class TopiaMetaTransformer
extends AbstractMetaTransformer<ObjectModel> {
    private static final Log log = LogFactory.getLog(TopiaMetaTransformer.class);
    protected static final ImmutableSet<String> FORBIDDEN_ATTRIBUTE_NAMES = ImmutableSet.of((Object)"analyze", (Object)"next", (Object)"value", (Object)"values", (Object)"begin", (Object)"end", (Object[])new String[]{"authorization", "order", "user", "when", "key"});
    protected static final ImmutableSet<String> FORBIDDEN_CLASS_NAMES = ImmutableSet.of((Object)"constraint", (Object)"user");

    public TopiaMetaTransformer() {
        this.setTemplateTypes(new Class[]{JavaInterfaceTransformer.class, BeanTransformer.class, JavaEnumerationTransformer.class, EntityTransformer.class, EntityHibernateMappingGenerator.class, EntityDaoTransformer.class, EntityEnumTransformer.class, ApplicationContextTransformer.class, PersistenceContextTransformer.class});
    }

    protected boolean validateModel(ObjectModel model) {
        boolean validationSuccess = true;
        for (ObjectModelValidator validator : this.getValidators(model)) {
            if (validator.validate()) continue;
            for (String error : validator.getErrors()) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("[VALIDATION] " + error));
            }
        }
        TopiaTemplateHelper templateHelper = new TopiaTemplateHelper(model);
        List<ObjectModelClass> classes = templateHelper.getEntityClasses(model, true);
        if (classes.isEmpty()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No entity to generate, " + ((Object)((Object)this)).getClass().getName() + " is skipped"));
            }
            validationSuccess = false;
        }
        return validationSuccess;
    }

    protected ImmutableSet<ObjectModelValidator> getValidators(ObjectModel model) {
        AttributeNamesValidator attributeNamesValidator = new AttributeNamesValidator(model);
        for (String sqlKeyword : FORBIDDEN_ATTRIBUTE_NAMES) {
            attributeNamesValidator.addNameAndReason(sqlKeyword, "Le nom d'attribut \"" + sqlKeyword + "\" est incompatible avec certains SGBD");
        }
        ClassNamesValidator classNamesValidator = new ClassNamesValidator(model);
        for (String sqlKeyword : FORBIDDEN_CLASS_NAMES) {
            classNamesValidator.addNameAndReason(sqlKeyword, "Le nom de classe \"" + sqlKeyword + "\" est incompatible avec certains SGBD");
        }
        TopiaJavaValidator topiaJavaValidator = new TopiaJavaValidator(model);
        TopiaRelationValidator topiaRelationValidator = new TopiaRelationValidator(model);
        return ImmutableSet.of((Object)attributeNamesValidator, (Object)classNamesValidator, (Object)((Object)topiaJavaValidator), (Object)((Object)topiaRelationValidator));
    }
}

