package org.nuiton.topia.security.entities.authorization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class TopiaAssociationAuthorizationAbstract extends TopiaAuthorizationImpl implements TopiaAssociationAuthorization {

    public String idBeginAssociation;
    public String nameAssociation;
    public int actions;
    public Set principals;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TopiaAssociationAuthorization.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TopiaAssociationAuthorization.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, ID_BEGIN_ASSOCIATION, String.class, idBeginAssociation);
        visitor.visit(this, NAME_ASSOCIATION, String.class, nameAssociation);
        visitor.visit(this, ACTIONS, int.class, actions);
        visitor.visit(this, PRINCIPALS, Set.class, principals);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setIdBeginAssociation :
     * @param value 
     */

    public void setIdBeginAssociation(String value) {
        String _oldValue = this.idBeginAssociation;
        fireOnPreWrite(ID_BEGIN_ASSOCIATION, _oldValue, value);
        this.idBeginAssociation = value;
        fireOnPostWrite(ID_BEGIN_ASSOCIATION, _oldValue, value);
}

    /**
     * getIdBeginAssociation :
     * @return String 
     */

    public String getIdBeginAssociation() {
        fireOnPreRead(ID_BEGIN_ASSOCIATION, idBeginAssociation);
        String result = this.idBeginAssociation;
        fireOnPostRead(ID_BEGIN_ASSOCIATION, idBeginAssociation);
        return result;
}

    /**
     * setNameAssociation :
     * @param value 
     */

    public void setNameAssociation(String value) {
        String _oldValue = this.nameAssociation;
        fireOnPreWrite(NAME_ASSOCIATION, _oldValue, value);
        this.nameAssociation = value;
        fireOnPostWrite(NAME_ASSOCIATION, _oldValue, value);
}

    /**
     * getNameAssociation :
     * @return String 
     */

    public String getNameAssociation() {
        fireOnPreRead(NAME_ASSOCIATION, nameAssociation);
        String result = this.nameAssociation;
        fireOnPostRead(NAME_ASSOCIATION, nameAssociation);
        return result;
}

    /**
     * setActions :
     * @param value 
     */

    public void setActions(int value) {
        int _oldValue = this.actions;
        fireOnPreWrite(ACTIONS, _oldValue, value);
        this.actions = value;
        fireOnPostWrite(ACTIONS, _oldValue, value);
}

    /**
     * getActions :
     * @return int 
     */

    public int getActions() {
        fireOnPreRead(ACTIONS, actions);
        int result = this.actions;
        fireOnPostRead(ACTIONS, actions);
        return result;
}

    /**
     * setPrincipals :
     * @param value 
     */

    public void setPrincipals(Set value) {
        Set _oldValue = this.principals;
        fireOnPreWrite(PRINCIPALS, _oldValue, value);
        this.principals = value;
        fireOnPostWrite(PRINCIPALS, _oldValue, value);
}

    /**
     * getPrincipals :
     * @return Set 
     */

    public Set getPrincipals() {
        fireOnPreRead(PRINCIPALS, principals);
        Set result = this.principals;
        fireOnPostRead(PRINCIPALS, principals);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(ID_BEGIN_ASSOCIATION, this.idBeginAssociation).
            append(NAME_ASSOCIATION, this.nameAssociation).
            append(ACTIONS, this.actions).
            append(PRINCIPALS, this.principals).
         toString();
        return result;
}


} //TopiaAssociationAuthorizationAbstract
