/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication.operation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.replication.ReplicationEngine;
import org.nuiton.topia.replication.TopiaReplicationOperation;
import org.nuiton.topia.replication.model.Link;
import org.nuiton.topia.replication.model.ReplicationModel;
import org.nuiton.topia.replication.model.ReplicationNode;
import org.nuiton.topia.replication.model.ReplicationOperationDef;
import org.nuiton.topia.replication.model.ReplicationOperationPhase;

public class AttachLink
implements TopiaReplicationOperation {
    private static final Log log = LogFactory.getLog(AttachLink.class);

    @Override
    public void register(ReplicationModel model, ReplicationNode ownerNode, ReplicationOperationPhase phase, Object ... parameters) {
        throw new UnsupportedOperationException(I18n._((String)"topia.replication.operation.error.uncreatable", (Object[])new Object[]{this.getClass()}));
    }

    @Override
    public void run(ReplicationOperationDef operationDef, TopiaContextImplementor srcCtxt, TopiaContextImplementor dstCtxt, List<? extends TopiaEntity> nodeEntities, Map<Class<? extends TopiaEntity>, List<String>> data) throws TopiaException {
        Link link = (Link)operationDef.getParameters()[0];
        String name = link.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("currentNode : " + operationDef.getNode() + " , link to attach : " + link));
        }
        ReplicationNode ownerNode = link.getSource();
        ReplicationNode cibleNode = link.getTarget();
        EntityOperator<? super TopiaEntity> ownerOperator = ownerNode.getOperator();
        List<String> associationIds = null;
        List<String> ownerIds = null;
        List<? extends TopiaEntity> ownerEntities = null;
        if (ownerNode.equals(operationDef.getNode())) {
            ownerIds = TopiaEntityHelper.getTopiaIdList(nodeEntities);
        }
        if (cibleNode.equals(operationDef.getNode())) {
            associationIds = TopiaEntityHelper.getTopiaIdList(nodeEntities);
        }
        if (ownerIds == null) {
            ownerIds = data.get(ownerNode.getContract().getContract());
        }
        if (associationIds == null) {
            associationIds = data.get(cibleNode.getContract().getContract());
        }
        if (ownerIds == null || ownerIds.isEmpty()) {
            log.info((Object)I18n._((String)"topia.replication.attachAssociation.nothing.to.do", (Object[])new Object[]{ownerOperator}));
            return;
        }
        ownerEntities = ReplicationEngine.getEntitiesList((TopiaContext)srcCtxt, ownerIds.toArray(new String[ownerIds.size()]));
        boolean shouldCommit = false;
        if (log.isInfoEnabled()) {
            log.info((Object)("ownerNode : " + ownerNode + " , targetNode : " + cibleNode + ", association : " + name));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("owner ids : " + ownerIds));
            log.debug((Object)("association ids : " + associationIds));
        }
        for (TopiaEntity topiaEntity : ownerEntities) {
            TopiaEntity dst;
            Collection dstTargetEntities;
            Collection targetEntities = (Collection)ownerOperator.get(name, topiaEntity);
            if (targetEntities == null || targetEntities.isEmpty()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("no association '" + name + "' attached to  " + topiaEntity));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("will try to attach " + targetEntities.size() + " association(s) '" + name + "' to " + topiaEntity));
            }
            List dstTargetAssociationsId = (dstTargetEntities = (Collection)ownerOperator.get(name, dst = dstCtxt.findByTopiaId(topiaEntity.getTopiaId()))) == null ? Collections.EMPTY_LIST : TopiaEntityHelper.getTopiaIdList((List)((List)dstTargetEntities));
            boolean shouldUpdate = false;
            for (Object a : targetEntities) {
                TopiaEntity assosiationSrc = (TopiaEntity)a;
                if (!associationIds.contains(assosiationSrc.getTopiaId())) continue;
                if (dstTargetAssociationsId.contains(assosiationSrc.getTopiaId())) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("already attached association '" + name + "' : " + assosiationSrc));
                    continue;
                }
                TopiaEntity assosiationDst = dstCtxt.findByTopiaId(assosiationSrc.getTopiaId());
                ownerOperator.addChild(name, dst, (Object)assosiationDst);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("will attach association '" + name + "' : " + assosiationDst));
                }
                shouldUpdate = true;
            }
            if (!shouldUpdate) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("will update " + dst.getTopiaId()));
            }
            shouldCommit = true;
        }
        if (shouldCommit) {
            dstCtxt.commitTransaction();
        }
    }
}

