/* *##% ToPIA - Replication service
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

/* *
 * IndexEngin.java
 *
 * Created: 8 oct. 06 17:15:00
 *
 * @author poussin
 * @version $Revision: 1459 $
 *
 * Last update: $Date: 2009-05-16 09:56:47 +0200 (Sat, 16 May 2009) $
 * by : $Author: tchemit $
 */
package org.nuiton.topia.replication;

import org.nuiton.topia.replication.model.ReplicationModel;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaService;
import org.nuiton.topia.persistence.TopiaEntityEnum;

/**
 * User visible interface for replication engin
 * 
 * To use replicator you must have properties defined in config file:
 * <li>topia.replication.engin=[class used to indexation]
 * <li>possible specific property for index engin used
 *
 * The replication is always done in two phases :
 *
 * <li> - prepare the replication model
 *   - ({@link #prepare(TopiaEntityEnum[], String[])}
 *   - ({@link #prepareForAll(TopiaEntityEnum[])}
 * 
 * <li> - lanch replication {@link #doReplicate(ReplicationModel, TopiaContext)}
 * 
 * @author chemit
 * @since 2.2.0
 */
public interface TopiaReplicationService extends TopiaService {

    public static final String SERVICE_NAME = "replication";

    /**
     * Prepare le modele de replication pour les entites dans les topiaIds sont
     * donnes.
     *
     * @param contracts les contrats a repliquer
     * @param topiaIds la liste des ids d'entites a repliquer
     * @return le model de replication initialise
     *
     * @throws TopiaException pour toute erreur recontree
     */
    ReplicationModel prepare(TopiaEntityEnum[] contracts, String... topiaIds) throws TopiaException;

    /**
     * Prepare le modele de replication pour toutes les entites des types donnes.
     *
     * La méthode calcule l'ordre de replication des données.
     *
     * Actuellement, on n'est pas capable de calculer l'ordre si le graphe des
     * entités contient des cycles.
     *
     * TODO : faire en sorte de pouvoir gérer les cycles.
     *
     * @param contracts les contrats des types a repliquer
     * @return le modele pour la replication
     * @throws TopiaException pour toute erreur rencontree
     */
    ReplicationModel prepareForAll(TopiaEntityEnum[] contracts) throws TopiaException;

    /**
     * Prepare le modele de replication pour les entites données en ne faisant 
     * pas de calcul sur l'ordre des entités à répliquer.
     * 
     * L'ordre des types donnees sera celui utilisé.
     *
     * @param contracts les contrats a repliquer (dans l'ordre donnée)
     * @param topiaIds les ids des entites a repliquer
     * @return le model de replication initialise
     *
     * @throws TopiaException pour toute erreur recontree
     */
    ReplicationModel prepareWithComputedOrder(TopiaEntityEnum[] contracts, String... topiaIds) throws TopiaException;

    /**
     * Ajouter une nouvelle operation pre-replication, sur un type de donnee.
     *
     * @param model le modele de replication
     * @param type le type du noeud de replication
     * @param operationClass l'implantation de l'operation
     * @param parameters les parametres supplementaires pour l'operation
     */
    void addBeforeOperation(ReplicationModel model, TopiaEntityEnum type, Class<? extends TopiaReplicationOperation> operationClass, Object... parameters);

    /**
     * Ajouter une nouvelle operation post-replication, sur un type de donnee.
     *
     * @param model le modele de replication
     * @param type le type du noeud de replication
     * @param operationClass l'implantation de l'operation
     * @param parameters les parametres supplementaires pour l'operation
     */
    void addAfterOperation(ReplicationModel model, TopiaEntityEnum type, Class<? extends TopiaReplicationOperation> operationClass, Object... parameters);

    /**
     * Lance l'operation de replication a partir du context source vers le
     * context de destination sur les entites donnees et en utilisant le model
     * de replication precedemment construit via la methode
     * {@link #prepare(TopiaEntityEnum[], String[])} ou
     * {@link #prepareForAll(TopiaEntityEnum[])}.
     *
     * @param model le modele de replication
     * @param dstCtxt le context sur la source de donnees ou repliquer
     * @throws Exception pour toute erreur pendant la replication
     */
    void doReplicate(ReplicationModel model, TopiaContext dstCtxt) throws Exception;
}


