/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.jdbc.Work;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.migration.MigrationServiceException;
import org.nuiton.topia.migration.TMSVersionPersister;
import org.nuiton.util.StringUtil;
import org.nuiton.util.version.Version;

public abstract class AbstractTopiaMigrationCallback {
    private static Log log = LogFactory.getLog(AbstractTopiaMigrationCallback.class);
    private TMSVersionPersister tmsVersionPersister;

    public abstract Version[] getAvailableVersions();

    public abstract Version getApplicationVersion();

    public abstract boolean askUser(Version var1, List<Version> var2);

    protected abstract void migrateForVersion(Version var1, TopiaContextImplementor var2, boolean var3, boolean var4) throws Exception;

    public boolean doMigration(TopiaContext ctxt, Version dbVersion, boolean showSql, boolean showProgression, List<Version> versions) throws MigrationServiceException {
        boolean doMigrate = this.askUser(dbVersion, versions);
        if (!doMigrate) {
            return false;
        }
        for (Version v : versions) {
            try {
                TopiaContextImplementor tx = (TopiaContextImplementor)ctxt.beginTransaction();
                try {
                    log.info((Object)I18n.t((String)"topia.migration.start.migrate", (Object[])new Object[]{v}));
                    this.migrateForVersion(v, tx, showSql, showProgression);
                    this.tmsVersionPersister.saveVersion((TopiaContext)tx, v);
                    tx.commitTransaction();
                }
                catch (Exception eee) {
                    log.error((Object)"Migration impossible de la base", (Throwable)eee);
                    tx.rollbackTransaction();
                    throw new MigrationServiceException(I18n.t((String)"topia.migration.migration.failed", (Object[])new Object[]{v}), eee);
                }
                finally {
                    if (tx == null) continue;
                    tx.closeContext();
                }
            }
            catch (MigrationServiceException eee) {
                throw eee;
            }
            catch (Exception eee) {
                log.error((Object)"Error lors de la tentative de migration", (Throwable)eee);
                doMigrate = false;
                break;
            }
        }
        return doMigrate;
    }

    public void executeSQL(TopiaContextImplementor tx, String ... sqls) throws TopiaException {
        this.executeSQL(tx, false, false, sqls);
    }

    public void executeSQL(TopiaContextImplementor tx, final boolean showSql, final boolean showProgression, final String ... sqls) throws TopiaException {
        LinkedHashSet<String> sqlsWithoutComments = new LinkedHashSet<String>();
        for (String sql : sqls) {
            if (sql.trim().startsWith("--")) continue;
            sqlsWithoutComments.add(sql);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"topia.migration.start.sqls", (Object[])new Object[]{sqlsWithoutComments.size()}));
        }
        if (showSql) {
            StringBuilder buffer = new StringBuilder();
            for (String s : sqlsWithoutComments) {
                buffer.append(s).append("\n");
            }
            log.info((Object)("SQL TO EXECUTE :\n--------------------------------------------------------------------------------\n--------------------------------------------------------------------------------\n" + buffer.toString() + "--------------------------------------------------------------------------------\n" + "--------------------------------------------------------------------------------\n"));
        }
        tx.getHibernate().doWork(new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection connection) throws SQLException {
                int index = 0;
                int max = sqls.length;
                for (String sql : sqls) {
                    ++index;
                    long t0 = System.nanoTime();
                    if (log.isInfoEnabled()) {
                        String message = "";
                        if (showProgression) {
                            message = I18n.t((String)"topia.migration.start.sql", (Object[])new Object[]{index, max});
                        }
                        if (showSql) {
                            message = message + "\n" + sql;
                        }
                        if (showProgression || showSql) {
                            log.info((Object)message);
                        }
                    }
                    PreparedStatement sta = connection.prepareStatement(sql);
                    try {
                        sta.executeUpdate();
                    }
                    finally {
                        sta.close();
                    }
                    if (!log.isDebugEnabled()) continue;
                    String message = I18n.t((String)"topia.migration.end.sql", (Object[])new Object[]{index, max, StringUtil.convertTime((long)(System.nanoTime() - t0))});
                    log.debug((Object)message);
                }
            }
        });
    }

    public void setTmsVersionPersister(TMSVersionPersister tmsVersionPersister) {
        this.tmsVersionPersister = tmsVersionPersister;
    }
}

