/* *##% 
 * ToPIA :: Service Migration
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/
package org.nuiton.topia.migration.callback;

import org.nuiton.topia.migration.DatabaseManager;

/**
 * MigrationCallBackHandler
 *
 * @author chatellier
 * @version $Revision: 1459 $
 *
 * Last update : $Date: 2009-05-16 09:56:47 +0200 (Sat, 16 May 2009) $
 * By : $Author: tchemit $
 */
public interface MigrationCallbackHandler {

    /**
     * CallbackHandler return type.
     */
    public static enum MigrationChoice {
        // no migration

        NO_MIGRATION,
        // migration
        MIGRATION,
        // migration done by application, only version managed
        CUSTOM_MIGRATION
    }

    /**
     * Ask for migration
     * 
     * @param dbManager objet permettant d'ouvrir des connexions sur la base
     * @param databaseVersion database version
     * @param applicationVersion application version
     * @return migration aggrement
     */
    public MigrationChoice doMigration(DatabaseManager dbManager, String databaseVersion, String applicationVersion);
}
