/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.liquibase;

import java.io.File;
import java.util.Map;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.liquibase.TopiaLiquibaseService;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaConfiguration;
import org.nuiton.topia.persistence.TopiaMigrationServiceException;

public class TopiaLiquibaseServiceImpl
implements TopiaLiquibaseService {
    private static final Log log = LogFactory.getLog(TopiaLiquibaseServiceImpl.class);
    protected Contexts allContexts = new Contexts("");
    protected String changeLogPath = "db/changelog-master.xml";
    protected Database database;
    protected Liquibase liquibase;

    public void initTopiaService(TopiaApplicationContext topiaApplicationContext, Map<String, String> serviceConfiguration) {
        if (!serviceConfiguration.isEmpty()) {
            throw new UnsupportedOperationException("no configuration expected but " + String.valueOf(serviceConfiguration) + " given");
        }
        try {
            ResourceAccessor resourceAccessor = this.getResourceAccessor();
            this.database = this.openDatabase(topiaApplicationContext, resourceAccessor);
            this.liquibase = this.getLiquibase(this.database, resourceAccessor);
        }
        catch (LiquibaseException e) {
            this.close();
            throw new TopiaMigrationServiceException("unable to init liquibase", (Throwable)e);
        }
    }

    public String getSchemaVersion() {
        throw new UnsupportedOperationException("schema version is not made available by liquibase");
    }

    public void initOnCreateSchema() {
        if (log.isInfoEnabled()) {
            log.info((Object)"init liquibase");
        }
        try {
            this.liquibase.changeLogSync(this.allContexts);
        }
        catch (LiquibaseException e) {
            this.close();
            throw new TopiaMigrationServiceException("unable to init liquibase", (Throwable)e);
        }
    }

    public void runSchemaMigration() {
        if (log.isInfoEnabled()) {
            log.info((Object)"migrate schema with liquibase");
        }
        try {
            this.liquibase.update(this.allContexts);
        }
        catch (LiquibaseException e) {
            this.close();
            throw new TopiaMigrationServiceException("unable to update schema with liquibase", (Throwable)e);
        }
    }

    protected Liquibase getLiquibase(Database database, ResourceAccessor resourceAccessor) throws LiquibaseException {
        Liquibase liquibase = new Liquibase(this.changeLogPath, resourceAccessor, database);
        return liquibase;
    }

    protected ResourceAccessor getResourceAccessor() {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        ClassLoaderResourceAccessor threadClFO = new ClassLoaderResourceAccessor(contextClassLoader);
        ClassLoaderResourceAccessor clFO = new ClassLoaderResourceAccessor();
        FileSystemResourceAccessor fsFO = new FileSystemResourceAccessor(new File[0]);
        return new CompositeResourceAccessor(new ResourceAccessor[]{clFO, fsFO, threadClFO});
    }

    protected Database openDatabase(TopiaApplicationContext topiaApplicationContext, ResourceAccessor resourceAccessor) {
        TopiaConfiguration configuration = topiaApplicationContext.getConfiguration();
        String url = configuration.getJdbcConnectionUrl();
        String user = configuration.getJdbcConnectionUser();
        String password = configuration.getJdbcConnectionPassword();
        try {
            Database database = DatabaseFactory.getInstance().openDatabase(url, user, password, null, resourceAccessor);
            return database;
        }
        catch (DatabaseException e) {
            throw new TopiaMigrationServiceException("cannot get database for migration connection", (Throwable)e);
        }
    }

    protected void closeDatabase() {
        block3: {
            if (this.database != null) {
                try {
                    this.database.close();
                    this.database = null;
                }
                catch (DatabaseException e2) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)"error while trying to close database after liquibase error", (Throwable)e2);
                }
            }
        }
    }

    public void close() {
        this.closeDatabase();
    }
}

