/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.flyway;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.googlecode.flyway.core.Flyway;
import com.googlecode.flyway.core.util.Location;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.flyway.TopiaFlywayService;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaException;

public class TopiaFlywayServiceImpl
implements TopiaFlywayService {
    private static final Log log = LogFactory.getLog(TopiaFlywayServiceImpl.class);
    protected String flywayInitVersion = null;

    public void setConfiguration(Map<String, String> serviceConfiguration) {
        if (serviceConfiguration.containsKey("flyway.initVersion")) {
            this.flywayInitVersion = serviceConfiguration.get("flyway.initVersion");
            if (StringUtils.isBlank((CharSequence)this.flywayInitVersion)) {
                throw new IllegalArgumentException("'" + this.flywayInitVersion + "' must not be empty");
            }
        }
    }

    public Class<?>[] getPersistenceClasses() {
        return new Class[0];
    }

    public void preInit(TopiaApplicationContext topiaApplicationContext) {
        if (log.isInfoEnabled()) {
            log.info((Object)"init flyway service");
        }
        Flyway flyway = new Flyway();
        this.setDataSource(flyway, topiaApplicationContext);
        this.setLocations(flyway, topiaApplicationContext);
        this.doExtraConfiguration(flyway, topiaApplicationContext);
        if (this.isSchemaEmpty(flyway, topiaApplicationContext)) {
            this.createSchema(flyway, topiaApplicationContext);
        } else {
            this.migrateSchema(flyway, topiaApplicationContext);
        }
    }

    protected void setDataSource(Flyway flyway, TopiaApplicationContext topiaApplicationContext) {
        ImmutableMap configuration = topiaApplicationContext.getConfiguration();
        String url = (String)configuration.get("hibernate.connection.url");
        String user = (String)configuration.get("hibernate.connection.username");
        String password = (String)configuration.get("hibernate.connection.password");
        flyway.setDataSource(url, user, password);
    }

    protected void setLocations(Flyway flyway, TopiaApplicationContext topiaApplicationContext) {
        String classpathMigrationPackage = topiaApplicationContext.getClass().getPackage().getName() + ".migration";
        ImmutableSet defaultLocations = ImmutableSet.of((Object)"db/migration", (Object)classpathMigrationPackage);
        LinkedHashSet<String> locations = new LinkedHashSet<String>();
        for (String defaultLocation : defaultLocations) {
            if (log.isInfoEnabled()) {
                log.info((Object)("will search for migration in location " + defaultLocation));
            }
            try {
                Location location = new Location(defaultLocation);
                Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(location.getPath());
                if (resources.hasMoreElements()) {
                    locations.add(defaultLocation);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("migrations found in " + defaultLocation));
                    continue;
                }
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("no migration found in " + defaultLocation));
            }
            catch (IOException e) {
                throw new TopiaException((Throwable)e);
            }
        }
        String[] locationsArray = locations.toArray(new String[locations.size()]);
        flyway.setLocations(locationsArray);
    }

    protected void doExtraConfiguration(Flyway flyway, TopiaApplicationContext topiaApplicationContext) {
    }

    protected boolean isSchemaEmpty(Flyway flyway, TopiaApplicationContext topiaApplicationContext) {
        boolean schemaEmpty = topiaApplicationContext.isSchemaEmpty();
        return schemaEmpty;
    }

    protected void createSchema(Flyway flyway, TopiaApplicationContext topiaApplicationContext) {
        String initVersion = topiaApplicationContext.getModelVersion();
        if (log.isInfoEnabled()) {
            log.info((Object)"schema is empty, ignore migrations and let topia create schema");
        }
        topiaApplicationContext.createSchema();
        if (log.isInfoEnabled()) {
            log.info((Object)("init flyway to version " + initVersion));
        }
        flyway.setInitVersion(initVersion);
        flyway.setInitDescription("schema creation called on application context by topia flyway service");
        flyway.init();
    }

    protected void migrateSchema(Flyway flyway, TopiaApplicationContext topiaApplicationContext) {
        if (this.flywayInitVersion == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"schema exists, no flywayInitVersion found, let suppose flyway is already initialized");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("schema exists, will ask flyway to init if necessary to version " + this.flywayInitVersion));
            }
            flyway.setInitOnMigrate(true);
            flyway.setInitVersion(this.flywayInitVersion);
        }
        String targetVersion = topiaApplicationContext.getModelVersion();
        if (log.isInfoEnabled()) {
            log.info((Object)("schema exists, will run flyway migration up to target version " + targetVersion));
        }
        flyway.setTarget(targetVersion);
        if (log.isInfoEnabled()) {
            log.info((Object)"run flyway migration");
        }
        flyway.migrate();
    }

    public void postInit(TopiaApplicationContext applicationContext) {
    }
}

