/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.pager;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.persistence.pager.FilterRule;
import org.nuiton.topia.persistence.pager.FilterRuleGroupOperator;
import org.nuiton.topia.persistence.pager.FilterRuleOperator;
import org.nuiton.topia.persistence.pager.TopiaPagerBean;

public class TopiaPagerBeanBuilder {
    protected final TopiaPagerBean bean;

    public TopiaPagerBeanBuilder() {
        this(new TopiaPagerBean());
    }

    public TopiaPagerBeanBuilder(TopiaPagerBean bean) {
        this.bean = bean;
    }

    public TopiaPagerBeanBuilder setFilterRuleGroup(FilterRuleGroupOperator groupOp) {
        this.bean.setGroupOp(groupOp);
        return this;
    }

    public TopiaPagerBeanBuilder setSortcolumn(String sortColumn) {
        this.bean.setSortColumn(sortColumn);
        return this;
    }

    public TopiaPagerBeanBuilder setSortAscendant(boolean sortAscendant) {
        this.bean.setSortAscendant(sortAscendant);
        return this;
    }

    public TopiaPagerBeanBuilder setFilterOperationGroup(String groupOp) {
        this.setFilterRuleGroup(FilterRuleGroupOperator.valueOf(groupOp));
        return this;
    }

    public TopiaPagerBeanBuilder addRules(Collection<Map<String, String>> rules) {
        for (Map<String, String> rule : rules) {
            this.addRule(rule);
        }
        return this;
    }

    public TopiaPagerBeanBuilder addRule(String op, String property, String value) {
        FilterRuleOperator operator = FilterRuleOperator.valueOf(op);
        return this.addRule(new FilterRule(operator, property, value));
    }

    public TopiaPagerBeanBuilder addRule(Map<String, String> ruleMap) {
        String op = ruleMap.get("op");
        String property = ruleMap.get("field");
        String value = ruleMap.get("data");
        return this.addRule(op, property, value);
    }

    public TopiaPagerBeanBuilder addRule(FilterRule rule) {
        List<FilterRule> rules = this.bean.getRules();
        if (rules == null) {
            rules = new LinkedList<FilterRule>();
            this.bean.setRules(rules);
        }
        rules.add(rule);
        return this;
    }

    public TopiaPagerBean toBean() {
        return this.bean;
    }
}

