/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.event.spi.SaveOrUpdateEventListener;
import org.hibernate.service.Service;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.service.spi.Stoppable;
import org.nuiton.topia.persistence.TopiaNotFoundException;
import org.nuiton.topia.persistence.TopiaService;
import org.nuiton.topia.persistence.internal.TopiaHibernateSessionRegistry;
import org.nuiton.topia.persistence.internal.support.TopiaHibernateEventListener;
import org.nuiton.topia.persistence.support.TopiaServiceSupport;
import org.nuiton.topia.persistence.util.TopiaUtil;

public class HibernateProvider {
    private static final Log log = LogFactory.getLog(HibernateProvider.class);
    protected SessionFactory hibernateSessionFactory;
    protected Configuration hibernateConfiguration;
    protected Map<String, String> configuration;
    protected TopiaServiceSupport topiaServiceSupport;
    protected TopiaHibernateSessionRegistry sessionRegistry;
    protected List<Class<?>> persistentClasses = Lists.newArrayList();

    public HibernateProvider(Map<String, String> configuration, TopiaServiceSupport topiaServiceSupport, TopiaHibernateSessionRegistry sessionRegistry) {
        this.configuration = configuration;
        this.topiaServiceSupport = topiaServiceSupport;
        this.sessionRegistry = sessionRegistry;
    }

    protected String getProperty(String key) {
        return this.getProperty(key, null);
    }

    protected String getProperty(String key, String defaultValue) {
        String result = defaultValue;
        if (this.configuration.containsKey(key)) {
            result = this.configuration.get(key);
        }
        return result;
    }

    public List<Class<?>> getPersistentClasses() {
        if (this.persistentClasses.isEmpty()) {
            this.getHibernateConfiguration();
        }
        return this.persistentClasses;
    }

    public Configuration getHibernateConfiguration() {
        if (this.hibernateConfiguration == null) {
            this.hibernateConfiguration = this.newHibernateConfiguration();
            TopiaUtil.warnOnAutomaticSchemaOperationRisk(this.hibernateConfiguration);
            this.hibernateConfiguration.buildMappings();
        }
        return this.hibernateConfiguration;
    }

    public Configuration newHibernateConfiguration() {
        String[] classes;
        String[] dirs;
        Configuration result = new Configuration();
        for (String dir : dirs = this.getProperty("topia.persistence.directories", "").split(",")) {
            if (!StringUtils.isNotEmpty((CharSequence)(dir = dir.trim()))) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Load persistence from dir : " + dir));
            }
            result.addDirectory(new File(dir));
        }
        HashSet hibernatePersistanceClasses = new HashSet();
        for (TopiaService service : this.topiaServiceSupport.getServices().values()) {
            Class<?>[] classes2 = service.getPersistenceClasses();
            if (classes2 == null) continue;
            hibernatePersistanceClasses.addAll(Arrays.asList(classes2));
        }
        String listPersistenceClasses = this.getProperty("topia.persistence.classes", "");
        for (String classname : classes = listPersistenceClasses.split(",")) {
            Class<?> clazz;
            if (!StringUtils.isNotEmpty((CharSequence)(classname = classname.trim()))) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Load persistent class : " + classname));
            }
            try {
                clazz = Class.forName(classname);
            }
            catch (ClassNotFoundException eee) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Class " + classname + " not found"));
                }
                throw new TopiaNotFoundException(String.format("Persistence class %1$s not found", classname));
            }
            this.persistentClasses.add(clazz);
            hibernatePersistanceClasses.add(clazz);
        }
        for (Class clazz : hibernatePersistanceClasses) {
            result.addClass(clazz);
        }
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)result.getProperties());
        prop.putAll(this.configuration);
        Properties properties = TopiaUtil.getProperties(this.getProperty("topia.persistence.properties.file"));
        if (!properties.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Load properties from file : " + properties));
            }
            prop.putAll((Map<?, ?>)properties);
        }
        result.setProperties(prop);
        return result;
    }

    protected static StandardServiceRegistry getStandardServiceRegistry(SessionFactory sessionFactory) {
        SessionFactory.SessionFactoryOptions sessionFactoryOptions = sessionFactory.getSessionFactoryOptions();
        StandardServiceRegistry result = sessionFactoryOptions.getServiceRegistry();
        return result;
    }

    protected static SessionFactoryServiceRegistry getSessionFactoryServiceRegistry(SessionFactory sessionFactory) {
        SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)sessionFactory;
        SessionFactoryServiceRegistry result = (SessionFactoryServiceRegistry)sessionFactoryImplementor.getServiceRegistry();
        return result;
    }

    public static <S extends Service> S getHibernateService(SessionFactory sessionFactory, Class<S> serviceClass) {
        SessionFactoryServiceRegistry serviceRegistry = HibernateProvider.getSessionFactoryServiceRegistry(sessionFactory);
        Service result = serviceRegistry.getService(serviceClass);
        return (S)result;
    }

    public void close() {
        if (this.hibernateSessionFactory != null) {
            Preconditions.checkState((!this.hibernateSessionFactory.isClosed() ? 1 : 0) != 0);
            ConnectionProvider service = HibernateProvider.getHibernateService(this.hibernateSessionFactory, ConnectionProvider.class);
            if (service instanceof Stoppable) {
                Stoppable stoppable = (Stoppable)service;
                stoppable.stop();
            }
            this.hibernateSessionFactory.close();
        }
    }

    public SessionFactory getSessionFactory() {
        if (this.hibernateSessionFactory == null) {
            Configuration effectiveHibernateConfiguration = this.getHibernateConfiguration();
            this.hibernateSessionFactory = TopiaUtil.newSessionFactory(effectiveHibernateConfiguration);
            EventListenerRegistry eventListenerRegistry = HibernateProvider.getHibernateService(this.hibernateSessionFactory, EventListenerRegistry.class);
            TopiaHibernateEventListener listener = new TopiaHibernateEventListener(this.sessionRegistry);
            eventListenerRegistry.appendListeners(EventType.PRE_INSERT, (Object[])new PreInsertEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.PRE_LOAD, (Object[])new PreLoadEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.PRE_UPDATE, (Object[])new PreUpdateEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.PRE_DELETE, (Object[])new PreDeleteEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.POST_LOAD, (Object[])new PostLoadEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.POST_UPDATE, (Object[])new PostUpdateEventListener[]{listener});
            eventListenerRegistry.appendListeners(EventType.POST_DELETE, (Object[])new PostDeleteEventListener[]{listener});
            eventListenerRegistry.prependListeners(EventType.SAVE_UPDATE, (Object[])new SaveOrUpdateEventListener[]{listener});
        }
        return this.hibernateSessionFactory;
    }
}

