/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.event;

import java.util.EventObject;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.event.EntityState;

public class TopiaTransactionEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    private Map<TopiaEntity, EntityState> entities = new IdentityHashMap<TopiaEntity, EntityState>();

    public TopiaTransactionEvent(TopiaPersistenceContext source) {
        super(source);
    }

    public TopiaTransactionEvent(TopiaPersistenceContext source, Map<TopiaEntity, EntityState> entities) {
        this(source);
        this.entities.putAll(entities);
    }

    public Set<TopiaEntity> getEntities() {
        return this.entities.keySet();
    }

    public boolean isLoaded(TopiaEntity entity) {
        EntityState state = this.entities.get(entity);
        return state != null && state.isLoaded();
    }

    public boolean isRead(TopiaEntity entity) {
        EntityState state = this.entities.get(entity);
        return state != null && state.isRead();
    }

    public boolean isCreated(TopiaEntity entity) {
        EntityState state = this.entities.get(entity);
        return state != null && state.isCreated();
    }

    public boolean isWritten(TopiaEntity entity) {
        EntityState state = this.entities.get(entity);
        return state != null && state.isWritten();
    }

    public boolean isUpdated(TopiaEntity entity) {
        EntityState state = this.entities.get(entity);
        return state != null && state.isUpdated();
    }

    public boolean isDeleted(TopiaEntity entity) {
        EntityState state = this.entities.get(entity);
        return state != null && state.isDeleted();
    }

    public boolean isModification(TopiaEntity entity) {
        EntityState state = this.entities.get(entity);
        return state != null && (state.isCreated() || state.isUpdated() || state.isDeleted());
    }

    @Override
    public TopiaPersistenceContext getSource() {
        return (TopiaPersistenceContext)super.getSource();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.entities != null) {
            this.entities.clear();
            this.entities = null;
        }
    }
}

