/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal.support;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaNotFoundException;
import org.nuiton.topia.persistence.TopiaService;
import org.nuiton.topia.persistence.internal.AbstractTopiaApplicationContext;
import org.nuiton.topia.persistence.support.TopiaServiceSupport;

public class TopiaServiceSupportImpl
implements TopiaServiceSupport {
    private static final Log log = LogFactory.getLog(TopiaServiceSupportImpl.class);
    protected ImmutableMap<String, TopiaService> services;
    protected AbstractTopiaApplicationContext applicationContext;

    public TopiaServiceSupportImpl(AbstractTopiaApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.services = this.loadServices(applicationContext.getConfiguration());
    }

    public void init() {
        this.preInitServices((Map<String, TopiaService>)this.services);
        this.applicationContext.getHibernateProvider().getHibernateConfiguration();
        this.postInitServices((Map<String, TopiaService>)this.services);
    }

    protected void preInitServices(Map<String, TopiaService> services) {
        for (TopiaService service : services.values()) {
            if (service.preInit(this.applicationContext)) continue;
            log.warn((Object)String.format("The service named '%1$s' could not be post-initialized (service not activated)", service.getServiceName()));
        }
    }

    protected void postInitServices(Map<String, TopiaService> services) {
        for (TopiaService service : services.values()) {
            if (service.postInit(this.applicationContext)) continue;
            log.warn((Object)String.format("The service named '%1$s' could not be pre-initialized (service not activated)", service.getServiceName()));
        }
    }

    protected <E extends TopiaService> String getServiceName(Class<E> interfaceService) throws IllegalAccessException, NoSuchFieldException {
        Field f = interfaceService.getField("SERVICE_NAME");
        String name = (String)f.get(null);
        return name;
    }

    protected String getProperExceptionMessage(Throwable eee) {
        return eee.getClass().getSimpleName() + " : " + eee.getMessage();
    }

    protected ImmutableMap<String, TopiaService> loadServices(ImmutableMap<String, String> configuration) {
        HashMap<String, TopiaService> result = new HashMap<String, TopiaService>();
        for (String key : configuration.keySet()) {
            if (!key.matches("^topia\\.service\\.\\w+$")) continue;
            String serviceClass = (String)configuration.get((Object)key);
            try {
                Class<?> forName = Class.forName(serviceClass);
                Object newInstance = forName.getConstructor(new Class[0]).newInstance(new Object[0]);
                TopiaService service = (TopiaService)newInstance;
                if (key.equals("topia.service." + service.getServiceName())) {
                    result.put(service.getServiceName(), service);
                    log.info((Object)String.format("Service '%1$s' loaded (implementation %2$s)", key, serviceClass));
                    continue;
                }
                log.warn((Object)String.format("The service with key '%1$s' has a different name '%2$s'! (service not activated)", key, service.getServiceName()));
            }
            catch (Throwable eee) {
                String message = String.format("The service %1$s of type %2$s was not found.", key, serviceClass);
                if (log.isDebugEnabled()) {
                    log.debug((Object)message, eee);
                    continue;
                }
                if (!log.isErrorEnabled()) continue;
                log.error((Object)message);
            }
        }
        return ImmutableMap.copyOf(result);
    }

    @Override
    public <E extends TopiaService> boolean serviceEnabled(Class<E> interfaceService) {
        boolean result;
        block3: {
            result = false;
            try {
                String name = this.getServiceName(interfaceService);
                result = this.getServices().containsKey(name);
            }
            catch (Exception eee) {
                String format = "The service named '%1$s' could not be found for following reason: %2$s";
                String message = String.format(format, interfaceService, this.getProperExceptionMessage(eee));
                if (log.isDebugEnabled()) {
                    log.debug((Object)message, (Throwable)eee);
                }
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)message);
            }
        }
        return result;
    }

    @Override
    public <E extends TopiaService> E getService(Class<E> interfaceService) throws TopiaNotFoundException {
        TopiaService result;
        try {
            String name = this.getServiceName(interfaceService);
            result = this.getServices().get(name);
        }
        catch (Exception eee) {
            String format = "Could not retreave service %1$s for following reason: %2$s";
            String message = String.format(format, interfaceService, this.getProperExceptionMessage(eee));
            throw new TopiaNotFoundException(message, eee);
        }
        if (result == null) {
            String message = String.format("The service %1$s was not found.", interfaceService);
            throw new TopiaNotFoundException(message);
        }
        return (E)result;
    }

    @Override
    public Map<String, TopiaService> getServices() {
        return this.services;
    }
}

