/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal.support;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.jdbc.Work;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;
import org.nuiton.topia.persistence.support.TopiaSqlQuery;
import org.nuiton.topia.persistence.support.TopiaSqlSupport;
import org.nuiton.topia.persistence.support.TopiaSqlWork;

public class HibernateTopiaSqlSupport
implements TopiaSqlSupport {
    protected TopiaHibernateSupport hibernateSupport;

    public HibernateTopiaSqlSupport(TopiaHibernateSupport hibernateSupport) {
        this.hibernateSupport = hibernateSupport;
    }

    @Override
    public void executeSql(String sqlScript) {
        HibernateSqlWork work = new HibernateSqlWork(sqlScript);
        try {
            this.hibernateSupport.getHibernateSession().doWork((Work)work);
        }
        catch (HibernateException e) {
            throw new TopiaException("Could not execute sql code", e);
        }
    }

    @Override
    public void doSqlWork(TopiaSqlWork sqlWork) {
        HibernateTopiaSqlWork work = new HibernateTopiaSqlWork(sqlWork);
        try {
            this.hibernateSupport.getHibernateSession().doWork((Work)work);
        }
        catch (HibernateException e) {
            throw new TopiaException("Could not execute sql code", e);
        }
    }

    @Override
    public <O> O findSingleResult(TopiaSqlQuery<O> query) throws TopiaException {
        HibernateTopiaSqlQueryWork<O> work = new HibernateTopiaSqlQueryWork<O>(query, false);
        this.hibernateSupport.getHibernateSession().doWork(work);
        List<O> result = work.getResult();
        return result.isEmpty() ? null : (O)result.get(0);
    }

    @Override
    public <O> List<O> findMultipleResult(TopiaSqlQuery<O> query) throws TopiaException {
        HibernateTopiaSqlQueryWork<O> work = new HibernateTopiaSqlQueryWork<O>(query, true);
        this.hibernateSupport.getHibernateSession().doWork(work);
        List<O> result = work.getResult();
        return result;
    }

    public static class HibernateTopiaSqlQueryWork<O>
    implements Work {
        protected final TopiaSqlQuery<O> query;
        protected final boolean multipleResult;
        protected final List<O> result = new ArrayList<O>();

        public HibernateTopiaSqlQueryWork(TopiaSqlQuery<O> query, boolean multipleResult) {
            this.query = query;
            this.multipleResult = multipleResult;
        }

        public void execute(Connection connection) throws SQLException {
            PreparedStatement ps = this.query.prepareQuery(connection);
            try {
                ResultSet set = ps.executeQuery();
                this.query.afterExecuteQuery(set);
                if (set.next()) {
                    O singleResult = this.query.prepareResult(set);
                    if (singleResult != null) {
                        this.result.add(singleResult);
                    }
                    if (this.multipleResult) {
                        while (set.next()) {
                            singleResult = this.query.prepareResult(set);
                            if (singleResult == null) continue;
                            this.result.add(singleResult);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new TopiaException("Could not execute query", e);
            }
            finally {
                ps.close();
            }
        }

        public List<O> getResult() {
            return this.result;
        }
    }

    public static class HibernateTopiaSqlWork
    implements Work {
        protected final TopiaSqlWork work;

        public HibernateTopiaSqlWork(TopiaSqlWork work) {
            this.work = work;
        }

        public void execute(Connection connection) throws SQLException {
            this.work.execute(connection);
        }
    }

    public static class HibernateSqlWork
    implements Work {
        protected final String script;

        public HibernateSqlWork(String script) {
            this.script = script;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Connection connection) throws SQLException {
            PreparedStatement sta = connection.prepareStatement(this.script);
            try {
                sta.execute();
            }
            finally {
                sta.close();
            }
        }
    }
}

