/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.nuiton.topia.persistence.TopiaEntity;

public class HqlAndParametersBuilder<E extends TopiaEntity> {
    protected Class<E> entityClass;
    protected Set<String> whereClauses = Sets.newLinkedHashSet();
    protected Map<String, Object> parameters = Maps.newLinkedHashMap();
    protected Set<String> orderByArguments;
    protected String alias = "topiaEntity_";

    public void setAlias(String alias) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)alias));
        this.alias = alias;
    }

    public HqlAndParametersBuilder(Class<E> entityClass) {
        this.entityClass = entityClass;
    }

    public void addNull(String property) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)property));
        this.whereClauses.add(this.alias + "." + property + " is null");
    }

    public void addNotNull(String property) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)property));
        this.whereClauses.add(this.alias + "." + property + " is not null");
    }

    public void addEquals(String property, Object value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)property));
        if (value == null) {
            this.addNull(property);
        } else {
            String hqlParameterName = this.putHqlParameterWithAvailableName(property, value);
            this.whereClauses.add(this.alias + "." + property + " = :" + hqlParameterName);
        }
    }

    public void addNotEquals(String property, Object value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)property));
        if (value == null) {
            this.addNotNull(property);
        } else {
            String hqlParameterName = this.putHqlParameterWithAvailableName(property, value);
            this.whereClauses.add(this.alias + "." + property + " != :" + hqlParameterName);
        }
    }

    public void addIn(String property, Iterable<?> values) {
        this.addInOrNotIn(property, values, true);
    }

    public void addNotIn(String property, Iterable<?> values) {
        this.addInOrNotIn(property, values, false);
    }

    protected void addInOrNotIn(String property, Iterable<?> values, boolean in) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)property));
        Preconditions.checkNotNull(values);
        String aliasedProperty = this.alias + "." + property;
        if (Iterables.size(values) == 1) {
            Object onlyElement = Iterables.getOnlyElement(values);
            if (in) {
                this.addEquals(property, onlyElement);
            } else {
                this.addNotEquals(property, onlyElement);
            }
        } else {
            String whereClause;
            String inClause;
            boolean propertyMayBeNull = false;
            LinkedHashSet hqlParameterNames = Sets.newLinkedHashSet();
            for (Object value : values) {
                if (value == null) {
                    propertyMayBeNull = true;
                    continue;
                }
                String hqlParameterName = this.putHqlParameterWithAvailableName(property, value);
                hqlParameterNames.add(hqlParameterName);
            }
            String inClauseValues = hqlParameterNames.isEmpty() ? "" : ":" + StringUtils.join((Iterable)hqlParameterNames, (String)", :");
            if (in) {
                inClause = aliasedProperty + " in (" + inClauseValues + ")";
                whereClause = propertyMayBeNull ? aliasedProperty + " is null or " + inClause : inClause;
            } else {
                inClause = aliasedProperty + " not in (" + inClauseValues + ")";
                whereClause = propertyMayBeNull ? aliasedProperty + " is not null and " + inClause : inClause;
            }
            this.whereClauses.add(whereClause);
        }
    }

    public void addTopiaIdEquals(String property, String topiaId) {
        Preconditions.checkNotNull((Object)topiaId);
        this.addEquals(property + "." + "topiaId", topiaId);
    }

    public void addTopiaIdIn(String property, Iterable<String> topiaIds) {
        this.addIn(property + "." + "topiaId", topiaIds);
    }

    public void addTopiaIdNotEquals(String property, String topiaId) {
        Preconditions.checkNotNull((Object)topiaId);
        this.addNotEquals(property + "." + "topiaId", topiaId);
    }

    public void addTopiaIdNotIn(String property, Iterable<String> topiaIds) {
        this.addNotIn(property + "." + "topiaId", topiaIds);
    }

    public void addContains(String property, Object value) {
        String hqlParameterName = this.putHqlParameterWithAvailableName(property, value);
        this.whereClauses.add(":" + hqlParameterName + " in elements(" + this.alias + "." + property + ")");
    }

    public void addNotContains(String property, Object value) {
        String hqlParameterName = this.putHqlParameterWithAvailableName(property, value);
        this.whereClauses.add(":" + hqlParameterName + " not in elements(" + this.alias + "." + property + ")");
    }

    public void addWhereClause(String whereClause) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)whereClause));
        this.whereClauses.add(whereClause);
    }

    public void addWhereClause(String whereClause, Map<String, Object> hqlParameters) {
        Preconditions.checkNotNull(hqlParameters);
        boolean noCollision = Sets.intersection(this.parameters.keySet(), hqlParameters.keySet()).isEmpty();
        Preconditions.checkArgument((boolean)noCollision, (Object)("given arguments " + hqlParameters.keySet() + " contains a conflicting name with the already defined parameters of the query (" + this.parameters.keySet() + "). You should changes the names of given arguments."));
        this.addWhereClause(whereClause);
        this.parameters.putAll(hqlParameters);
    }

    public void setWhereClauses(Set<String> whereClauses) {
        Preconditions.checkNotNull(whereClauses);
        this.whereClauses = whereClauses;
    }

    public Set<String> getWhereClauses() {
        return this.whereClauses;
    }

    public void setParameters(Map<String, Object> parameters) {
        Preconditions.checkNotNull(parameters);
        this.parameters = parameters;
    }

    public void setOrderByArguments(Set<String> orderByArguments) {
        Preconditions.checkNotNull(orderByArguments);
        this.orderByArguments = orderByArguments;
    }

    public void setOrderByArguments(String ... orderByArguments) {
        LinkedHashSet orderByArgumentsAsSet = Sets.newLinkedHashSet();
        orderByArgumentsAsSet.addAll(Arrays.asList(orderByArguments));
        this.orderByArguments = orderByArgumentsAsSet;
    }

    public String getHql() {
        StringBuilder hqlStringBuilder = new StringBuilder();
        hqlStringBuilder.append("from ").append(this.entityClass.getCanonicalName()).append(" ").append(this.alias);
        if (!this.whereClauses.isEmpty()) {
            hqlStringBuilder.append(" where (").append(StringUtils.join(this.whereClauses, (String)") and (")).append(")");
        }
        if (CollectionUtils.isNotEmpty(this.orderByArguments)) {
            hqlStringBuilder.append(" order by ").append(this.alias).append(".").append(StringUtils.join(this.orderByArguments, (String)(", " + this.alias + ".")));
        }
        String hql = hqlStringBuilder.toString();
        return hql;
    }

    protected String getParameterName(String propertyName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)propertyName));
        String capitalize = WordUtils.capitalize((String)propertyName, (char[])new char[]{'.'});
        String withoutDots = capitalize.replaceAll("\\.", "");
        String parameterName = StringUtils.uncapitalize((String)withoutDots);
        return parameterName;
    }

    protected String putHqlParameterWithAvailableName(String propertyName, Object value) {
        String parameterNamePrefix = this.getParameterName(propertyName);
        int suffix = 0;
        String parameterName = parameterNamePrefix;
        while (this.parameters.containsKey(parameterName)) {
            parameterName = parameterNamePrefix + ++suffix;
        }
        this.parameters.put(parameterName, value);
        return parameterName;
    }

    public Map<String, Object> getHqlParameters() {
        return this.parameters;
    }

    public boolean isOrderByClausePresent() {
        return CollectionUtils.isNotEmpty(this.orderByArguments);
    }
}

